﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <windows.h>
#include <cstdio>
#include <cstring>
#include <cstdlib>
#include <cmath>
#include <cassert>
#include <cstddef>

//namespace test {

// 型定義
typedef signed char  s8;
typedef signed short s16;
typedef int s32;
typedef signed long long s64;

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;
typedef unsigned long long u64;

typedef float f32;
typedef double f64;

typedef u8  bit8;
typedef u16 bit16;
typedef u32 bit32;
typedef u64 bit64;

typedef unsigned int uint;
typedef u16 char16;

typedef intptr_t sptr;
typedef uintptr_t uptr;

//} //namespace test

//============================================================
// デバッグ
//============================================================

#if (defined _WIN32)
#define TEST_HALT()         \
{                           \
    fflush(stdout);         \
    __debugbreak();         \
}
#else
#define TEST_HALT()         \
{                           \
    assert(0);              \
}
#endif

#if (defined _DEBUG)
#define TEST_PRINTF(...)   ((void)printf(__VA_ARGS__))
#else
#define TEST_PRINTF(...)   ((void)0)
#endif

#if (defined _DEBUG)
#define TEST_ASSERT(exp)                  \
{                                         \
    if (!(exp))                           \
    {                                     \
        TEST_PRINTF("Assert %s::%d\n",    \
                        __FILE__,         \
                        __LINE__);        \
        TEST_HALT();                      \
    }                                     \
}
#else
#define TEST_ASSERT(...)  ((void)0)
#endif
