﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/hid.h>
#include <nn/xcd/xcd.h>
#include <nnt/nntest.h>

/**
 * @brief   テスト単位の開始・終了処理を行うためのフィクスチャクラス
 */
class XcdTeraMcuBase : public ::testing::Test
{
protected:
    /**
     * @brief   共通開始処理。テスト開始時に実行される
     */
    virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief   テストの終了処理。テスト関数を抜けるときに実行される
     */
    virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE;

protected:

#if !defined(NNT_XCD_USE_NPAD)
    int                         m_GamePadIdCount;       //!< ゲームパッド ID の数
    nn::hid::BasicXpadId        m_GamePadIds[nn::hid::XpadIdCountMax];  //!< ゲームパッド ID のリスト
#endif  // if !defined(NNT_XCD_USE_NPAD)

    nn::xcd::DeviceHandle       m_DeviceHandle;         //!< XCD のハンドル

private:
    bool                        m_IsTeraMcuTestInitialized; //!< TeraMcu のテストの初期化フラグ
};
