﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_Tick.h>
#include <nn/hid.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/xcd/xcd.h>
#include <nnt/nntest.h>

#include "testXcd_TeraMcuFixture.h"

namespace
{

// 初期化する Npad の ID リスト
const nn::hid::NpadIdType NpadIds[] =
{
    nn::hid::NpadId::No1
};

const size_t NpadIdCountMax = sizeof(NpadIds) / sizeof(NpadIds[0]);

}  // anonymous

void XcdTeraMcuBase::SetUp() NN_NOEXCEPT
{
    ::testing::Test::SetUp();

    m_IsTeraMcuTestInitialized = true;

    nn::hid::InitializeNpad();

    // RightJoy のみ使用するモードに設定
    nn::hid::SetSupportedNpadStyleSet(nn::hid::NpadStyleJoyRight::Mask);

    // Npad の初期化
    nn::hid::SetSupportedNpadIdType(NpadIds, NpadIdCountMax);
    for (const auto& id : NpadIds)
    {
        nn::hid::SetNpadJoyAssignmentModeSingle(id);
    }
}

void XcdTeraMcuBase::TearDown() NN_NOEXCEPT
{

    if (m_IsTeraMcuTestInitialized)
    {
        // Tera MCU の終了処理
        m_IsTeraMcuTestInitialized = false;
    }

    ::testing::Test::TearDown();
}
