﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/hid.h>
#include <nn/hid/system/hid_Nfc.h>
#include <nn/xcd/xcd.h>
#include <nnt/nntest.h>

/**
 * xcd:sys で提供されている API の呼出しができることの確認
 */
TEST(XcdSmokeTest, BasicXcdSys)
{
    nn::xcd::DeviceHandle handle = nn::xcd::DeviceHandle::GetInvalidHandle();

    {
        nn::xcd::PeriodicDataFormat dataFormat;
        ASSERT_FALSE(
            nn::xcd::GetDataFormat(
                &dataFormat,
                handle).IsSuccess());
    }

    ASSERT_FALSE(
        nn::xcd::SetDataFormat(
            nn::xcd::PeriodicDataFormat_MCU,
            handle).IsSuccess());

    nn::xcd::McuState mcuState;
    ASSERT_FALSE(
        nn::xcd::GetMcuState(&mcuState, handle).IsSuccess());

    ASSERT_FALSE(
        nn::xcd::SetMcuState(nn::xcd::McuState_Idle, handle).IsSuccess());

    nn::os::SystemEventType nfcEvent;
    nn::os::SystemEventType nfcDetectEvent;
    ASSERT_TRUE(
        nn::os::CreateSystemEvent(
            &nfcEvent,
            nn::os::EventClearMode_ManualClear,
            true).IsSuccess());
    ASSERT_TRUE(
        nn::os::CreateSystemEvent(
            &nfcDetectEvent,
            nn::os::EventClearMode_ManualClear,
            true).IsSuccess());
    ASSERT_FALSE(
        nn::xcd::SetNfcEvent(&nfcEvent, &nfcDetectEvent, handle).IsSuccess());

    {
        nn::xcd::NfcInfo nfcInfo;
        ASSERT_FALSE(
            nn::xcd::GetNfcInfo(&nfcInfo, handle).IsSuccess());
    }

    {
        nn::xcd::NfcDiscoveryParameter parameter = {};
        ASSERT_FALSE(
            nn::xcd::StartNfcDiscovery(parameter, handle).IsSuccess());
    }

    {
        nn::xcd::NtagReadParameter parameter = {};
        ASSERT_FALSE(
            nn::xcd::StartNtagRead(parameter, handle).IsSuccess());
    }

    {
        nn::xcd::NtagWriteParameter parameter = {};
        ASSERT_FALSE(
            nn::xcd::StartNtagWrite(parameter, handle).IsSuccess());
    }

    {
        nn::xcd::NfcPassThruParameter parameter = {};
        ASSERT_FALSE(
            nn::xcd::SendNfcRawData(parameter, handle).IsSuccess());
    }

    ASSERT_FALSE(
        nn::xcd::StopNfcDiscovery(handle).IsSuccess());

    nn::os::DestroySystemEvent(&nfcEvent);
    nn::os::DestroySystemEvent(&nfcDetectEvent);
}
