﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

typedef struct DetectFrameInfo
{
    uint8_t bssid[6];
    uint8_t dataHash[8];
    uint32_t recvLength;
    uint32_t recvTimes;
} DetectFrameInfo_t;

typedef struct DetectContTxPara
{
    uint8_t hash[8];
    uint8_t mac[6];
    uint8_t isChange;
    uint32_t size;
    uint32_t interval;
    uint32_t seq;
} DetectContTxPara_t;

typedef struct TestAgentCmd
{
    char cmd[128];
} TestAgentCmd_t;

namespace TestAgent {

extern const char* APP_VERSION;
extern nn::os::MutexType m_RxBuffLock;
extern nn::os::MutexType m_CmdListLock;
extern nn::os::MutexType m_ContTxLock;

enum testAgentWlanMode
{
    WLAN_MODE_UNKNOWN = 0,
    WLAN_MODE_INFRA,
    WLAN_MODE_MASTER,
    WLAN_MODE_CLIENT,
    WLAN_MODE_DETECT_SA,
    WLAN_MODE_DETECT_HD,
};

int GetRecvStandAloneFrameCount() NN_NOEXCEPT;
void ClearRecvStandAloneFrameCount() NN_NOEXCEPT;
int GetAgentStatus() NN_NOEXCEPT;
int SetAgentStatus(int isTesting) NN_NOEXCEPT;
int GetCmdListIdx() NN_NOEXCEPT;
void* GetCmdListBuff() NN_NOEXCEPT;
void ClearCmdList() NN_NOEXCEPT;
int SetCmdList(char* cmd) NN_NOEXCEPT;
int GetHashFilterCount() NN_NOEXCEPT;
int SetHashFilter(uint8_t* hashData) NN_NOEXCEPT;
void ClearHashFilter() NN_NOEXCEPT;
int GetRecvDetectFrameCount() NN_NOEXCEPT;
void* GetRecvDetectFrameBuff() NN_NOEXCEPT;
void ClearRecvDetectFrameBuff() NN_NOEXCEPT;
int FindDetectFrameByHash(uint8_t* bssid, uint8_t* data, uint32_t dataSize);

int DetectStandAloneSetHashList() NN_NOEXCEPT;
int DetectStandAloneStart(int txInterval, int txCount, int idleCount,
                        int rxStart, int rxCount, uint8_t* hashData,
                        uint32_t dataSize, uint8_t channel) NN_NOEXCEPT;
int DetectStandAloneStop() NN_NOEXCEPT;
int DetectStandAloneStartFetchFrame() NN_NOEXCEPT;
int DetectStandAloneStopFetchFrame() NN_NOEXCEPT;
int DetectHostDrivenStart(uint32_t txInterval, int txCount, int idleCount,
                        int rxStart, int rxCount, uint8_t* hashData,
                        uint32_t dataSize, bool sendPeriodical,
                        uint8_t channel) NN_NOEXCEPT;
int DetectHostDrivenStop() NN_NOEXCEPT;
int DetectHostDrivenOneShot(uint8_t* hashData, uint32_t dataSize, uint8_t dataCmd,
                          uint8_t* mac, uint32_t seq) NN_NOEXCEPT;
int GetSendDetectFrameCount() NN_NOEXCEPT;
uint8_t* GetCurrentHash() NN_NOEXCEPT;
int DetectContTxThreadStart(uint8_t* hashData, uint32_t dataSize, uint8_t isChange,
                          uint8_t* mac, uint32_t seq, uint32_t txInterval) NN_NOEXCEPT;
int DetectContTxThreadStop() NN_NOEXCEPT;
int DetectSimulatePeerTx(uint8_t* hashData, uint8_t* mac, uint32_t count,
                       uint32_t dataSize) NN_NOEXCEPT;
int WlanDetectGetMacAddress(uint8_t *macAddr) NN_NOEXCEPT;
int SocketConnect(char* serverIp, int serverPort) NN_NOEXCEPT;
int SocketDisconnect(int socketId) NN_NOEXCEPT;
int WowlSetSocketInfo(int socketId) NN_NOEXCEPT;
int SendPing(char* IpAdder, int dataSize, int sendInterval, int sendCount) NN_NOEXCEPT;
int WlanStartIperf(char* ifName, char* para) NN_NOEXCEPT;
int WlanIfstate(char* ifName, char* buf) NN_NOEXCEPT;
int WlanIfconfig(char* ifName, bool state, bool dhcp, char* ipAddress) NN_NOEXCEPT;
int WlanInfraConnect(char* ssid, nn::wlan::Security* security) NN_NOEXCEPT;
int WlanInfraDisconnect() NN_NOEXCEPT;
int WlanInfraInitialize() NN_NOEXCEPT;
int WlanInfraUninitialize(char* ifName) NN_NOEXCEPT;
int WlanLocalInitialize(int mode) NN_NOEXCEPT;
int WlanLocalUninitialize(int mode) NN_NOEXCEPT;
int WlanDetectInitialize() NN_NOEXCEPT;
int WlanDetectUninitialize() NN_NOEXCEPT;

void Initialize() NN_NOEXCEPT;
void Uninitialize() NN_NOEXCEPT;

}
