﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace {
    /******************************************************/
    //  WLAN Local通信 境界値、例外値試験で使用する定義群
    /******************************************************/
    // Bufer
    const size_t BufferSize100k             = 100 * 1024;
    const size_t BufferSize200k             = 200 * 1024;

    const size_t AgingFrameBufferSize       = 1024;
    const size_t ActionFrameBufferSize      = 1024;
    const size_t DataFrameBufferSize        = 1024;

    const size_t GetActionFrameBufferSize   = 2 * 1024;

    // BSS channel
    const int16_t BssChannelmin = -1;
    const int16_t BssChannelmax = static_cast<int16_t>(nn::wlan::WirelessChannel_48ch);

    // Connect channel
    const int16_t Channelmin = -1;
    const int16_t Channelmax = static_cast<int16_t>(nn::wlan::WirelessChannel_165ch);

    // SSID
    const int Ssidsizemin = 1;
    const int Ssidsizemax = 32;

    // ssidCount
    const int Ssidcountmin = 0;
    const int Ssidcountmax = 10;

    // keyIdx
    // 最小値は仕様上 0であり変数もuintとなるため、最小値-1の試験は不可
    const int Keyinxmin = 0;
    const int Keyinxmax = 3;

    // channelCount
    // 最小値は仕様上 0であり変数もuintとなるため、最小値-1の試験は不可
    const int Channelcountsizemin = 0;
    const int Channelcountsizemax = 38;

    // channelScanTime
    const int Channelscantimedefault = -1;
    const int Channelscantimemin = 10;
    const int Channelscantimemax = 3000;

    // homeChannelTime
    const int Homechanneltimedefault = -1;
    const int Homechanneltimemin = -1;
    const int Homechanneltimemax = 500;

    // StartScan size
    const size_t Scansizemin = sizeof(nn::wlan::ScanResultHeader) + 1;

    // ScanIeMatchInfo
    const int MatchLengthmin = 0;
    const int MatchLengthmax = 255;

    // beaconLostTimeout
    const int Beaconlosttimemin = 1;
    const int Beaconlosttimemax = 30;

    // ConvertRssiToLinkLevel
    const int32_t Covertrssitolinklevelmin = INT_MIN;
    const int32_t RssiThreshold1_2_4G = -85;
    const int32_t RssiThreshold2_2_4G = -72;
    const int32_t RssiThreshold3_2_4G = -60;
    const int32_t RssiThreshold1_5G = -87;
    const int32_t RssiThreshold2_5G = -75;
    const int32_t RssiThreshold3_5G = -65;
    const int32_t Covertrssitolinklevelmax = INT_MAX;

    // IeType
    const nn::wlan::ManagementFrameType Iemin = nn::wlan::ManagementFrameType::ManagementFrameType_Beacon;
    const nn::wlan::ManagementFrameType Iemax = static_cast<nn::wlan::ManagementFrameType>(
            nn::wlan::ManagementFrameType::ManagementFrameType_Beacon   ||
            nn::wlan::ManagementFrameType::ManagementFrameType_ProbeRes ||
            nn::wlan::ManagementFrameType::ManagementFrameType_AssocRes ||
            nn::wlan::ManagementFrameType::ManagementFrameType_AuthRes  ||
            nn::wlan::ManagementFrameType::ManagementFrameType_ProbeReq ||
            nn::wlan::ManagementFrameType::ManagementFrameType_AssocReq
        );

    // PutFrameRaw size
    // 2KB未満
    const size_t FrameSizemax = 2 * 1024 - 1;

    // rxId
    const uint32_t RxIdmin = 0;
    const uint32_t RxIdmax = 0xFFFFFFFF;

    // ethertypes
    const uint16_t Ethertypes[] = {0x88B7};

    // RxentryCount
    const uint32_t RxEntryCountmin = 1;
    const uint32_t RxEntryCountmax = 16;

    // rxEntrycapacity
    const uint32_t RxEntryCapacitymin = 1;
    const uint32_t RxEntryCapacitymax = 96;

    // SetActionFrameWithBeacon size
    const size_t Setactionsizemin       = 5;
    const size_t Setactionsizenormal    = 100;
    const size_t setaction_size_max     = 1800;

    // GetActionFrame size
    const size_t Getactionsizemin = 1;
    //const size_t setaction_size_max = 0;

    // CreateRxEntryForActionFrame count
    const uint32_t Createrxcountmin = 1;
    const uint32_t Createrxcountmax = 5;
    const uint32_t Createrxcountnormal = 2;

    // CreateRxEntryForActionFrame capacity
    const uint32_t Createrxcapacitymin = 1;
    const uint32_t Createrxcapacitymax = nn::wlan::ActionFrameRxCapacityMax;
    const uint32_t Createrxcapacitynormal = 10;

    // inactivePeriod
    const  uint32_t InactivePeriodmin = 0;
    const  uint32_t InactivePeriodmax = 180;

    //  IeIndex
    const uint32_t Ieindexmin = 0;
    const uint32_t Ieindexmax = 0xFFFFFFFF;

    // SetMaxAssociationNumber
    const uint32_t ConnectClientlimitmin = 1;
    const uint32_t ConnectClientlimitmax = 7;

    // dwellTime
    const uint32_t DwellTime = 20;

    // ローカル通信用StaticAES鍵
    static const nn::Bit8 StaticAesKey[16] = {
            0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
            0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF
    };

    static const char* Ssid_max = "SSID_SSID_SSID_SSID_SSID_SSID_32";

    // localmasterの設定パラメータ
    const char LocalMasterTestShortSSID[]               = "0";
    const char LocalMasterTestSSID[]                    = "WlanTest";
    const char LocalMasterTest2SSID[]                   = "WlanTest2";
    const char LocalMasterTest3SSID[]                   = "WlanTest3";
    const char LocalMasterTest4SSID[]                   = "WlanTest4";
    const char LocalMasterTestLongSSID[]                = "0123456789abcdefghij0123456789ab";
    const char InflaTestSSID[]                          = "WlanTest";

    nn::Result gResult;

#define LocalMasterPasKey           "Passphrase- [!#$%&'()=^~@;+:*,.<>/?`@\"']|"
#define LocalMasterWep64PasKey      "01234"
#define LocalMasterWep128PasKey     "0123456789abc"
#define LocalMasterAes16Key         "0123456789abcdef"

    enum GetTestFrameType
    {
        FrameType_Invalid = 0,
        FrameType_Frame,
        FrameType_ActionFrame,
    };

    const nn::wlan::MasterBssParameters testMasterBss   = {
        1, false, 30, false, nn::wlan::RateSetLegacy_11gMask, nn::wlan::RateSetLegacy_11gMask,
        { nn::wlan::SecurityMode_Open, nn::wlan::SecurityMode_Open, 0, "" }, nn::wlan::Ssid(LocalMasterTestSSID), 100
    };
    const nn::wlan::ReceivedDataMatchInfo TestMatchInfo[] = {
        { { 0x00, 0x22, 0xAA, 0xBB, 0xCC }, 5 }
    };

    const nn::wlan::ReceivedDataMatchInfo TestNotMatchInfo[] = {
        { { 0x00, 0x11, 0xBB, 0xAA, 0xCC }, 5 }
    };

    const uint16_t TestEtherTypes[] = {
        0x88b7, 0x8878
    };

    const uint8_t TestActionFrameHeader[] = {
        0x7f, 0x00, 0x22, 0xAA, nn::wlan::ActionFrameType_Local
    };

    const uint32_t WlanSimpleTestMaxConnect             = 2;

    const int32_t StacSize                              = 64 * 1024;

    const uint32_t WlanTestGetFrameCount                = 100000;

    const uint32_t WlanTestAgingGetFrameCount           = 4294967295;

    const size_t WlanTestRecvBufferSize                 = 2 * 1024;

    const size_t WlanTestPacketBufferSize               = 512;

    const size_t WlanTestRatePacketBufferSize           = 1400;

    // NTD追加定義
    const size_t WlanTestRTTPacketBufferSize            = 80;

    const size_t WlanLocalFrameHeaderOffsetSize         = (nn::wlan::MacAddress::MacAddressSize * 2);

    const size_t WlanTestGetFramMineSize                = WlanLocalFrameHeaderOffsetSize + sizeof(uint16_t) + sizeof(nn::wlan::ReceivedDataMatchInfo::matchData) + sizeof(uint32_t);

    const int64_t WlanTestConnectTimeOut                = 180 * 1000;

    const int64_t WlanTestMasterWaitTimeOut             = 30 * 60 * 1000;

    const int64_t WlanTestClientWaitTimeOut             = 3000;

    const int64_t WlanMaxClientConnectTimeOut           = 30 * 60 * 1000;

    const int64_t WlanMaxClientWaitMsecTimeOut          = 10 * 60 * 1000;

    const int64_t WlanTestDisconnectTimeOut             = 30 * 1000;

    const int64_t WlanTestKeepAliveShortTimeOut         = 30 * 1000;

    const int64_t WlanTestKeepAliveLongTimeOut          = 5 * 60 * 1000;

    const int64_t WlanTestCancelWaitTime                = 3000;

    const int64_t WlanTestCancelFrameWaitTime           = 30000;

    const int64_t WlanTestErrorTestCancelFrameWaitTime  = 5000;

    // ldn scan time
    const int32_t WlanTestLdnScanTime                   = 110;

    const int64_t WlanTestBroadCastPacketBufferSize     = 600;

    // TCP受信バッファプールサイズ定義
    const size_t WlanWowlPoolSize                       = 200 * 1024;

    // TCP受信バッファサイズ定義
    const size_t WlanWowlPakcetSize                     = 2 * 1024;

    /******************************************************/
    //  機能試験で使用している定義群
    /******************************************************/
#define SDEVEDEV // SDEV EDEVのみ有効とする 製品版の場合は本デファインを無効にすること
    // Ping Data
    const int ping_data_size_1023 = 1023;
    const int ping_data_size_512 = 512;
    const int ping_data_size_64 = 64;
    const char ping_data[] = {
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,
        01,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7,8,9,0,1,2,3,4,5,6,7
    };

    // AP設定 SSID
    const char* ApSetting1_1_Ssid = "WPA-PSK(AES)";
    const char* ApSetting1_2_Ssid = "AP1-WEP64";
    const char* ApSetting1_3_Ssid = " ";
    const char* ApSetting1_4_Ssid = "AP1-WEP128";

    const char* ApSetting2_1_Ssid = "AP2-WPAWPA2-PSK_AES";
    const char* ApSetting2_2_Ssid = "AP2-XXXX-2G";
    const char* ApSetting2_3_Ssid = "AP2-WPA2_AES";
    const char* ApSetting2_4_Ssid = "AP2-XXXX-5G";

    const char* ApSetting3_1_Ssid = "AP3-WPA-PSK_TKIP";

    const char* ApSetting4_1_Ssid = "AP4[!#$%&'()=^~@;+:*,.<>/?`@\"']|";

    const char* ApSetting5_1_Ssid = "AP5-SharedWEP64";
    const char* ApSetting5_2_Ssid = "AP5-SharedWEP128";

    const char* wlan_test_1_Ssid = "wlan_test_1";
    const char* wlan_test_2_Ssid = "wlan_test_2";
    const char* wlan_test_3_Ssid = "wlan_test_3";
    const char* wlan_test_4_Ssid = "wlan_test_4";
    const char* wlan_test_5_Ssid = "wlan_test_5";

    static const uint8_t InfraMacAddress[] =
    {
        0xDC, 0xFB, 0x02, 0xA5, 0x31, 0x88
    };

    struct TestConnectParams
    {
        char SettingNo[4];
        nn::wlan::Ssid ssid;
        nn::wlan::MacAddress bssid;
        int16_t channel;
        nn::wlan::Security security;
        bool autoKeepAlive;
        int beaconLostTimeout;
    };

    struct TestMasterClientInfo
    {
        int32_t seqNumber;
        uint8_t sdevMacAddress[nn::wlan::MacAddress::MacAddressSize];
        char ssidArray[nn::wlan::Ssid::SsidLengthMax + 1];
    };

    TestConnectParams ConnectParams[] = {
        // AP設定 1-1
        { "1-1", nn::wlan::Ssid(ApSetting1_1_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_WpaAes, nn::wlan::SecurityMode_WpaAes, 0, "Passphrase- [!#$%&'()=^~@;+:*,.<>/?`@\"']|" }, true, 10 },
        // AP設定 1-2
        { "1-2", nn::wlan::Ssid(ApSetting1_2_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wep64Open, nn::wlan::SecurityMode_Wep64Open, 0, "3031323334" }, true, 10 },
        // AP設定 1-3
        { "1-3", nn::wlan::Ssid(ApSetting1_3_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wpa2Tkip, nn::wlan::SecurityMode_Wpa2Tkip, 0, "12345678" }, true, 10 },
        // AP設定 1-4
        { "1-4", nn::wlan::Ssid(ApSetting1_4_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wep128Open, nn::wlan::SecurityMode_Wep128Open, 0, "30313233343536373839616263" }, true, 10 },
        // AP設定 2-1
        { "2-1", nn::wlan::Ssid(ApSetting2_1_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wpa2Aes, nn::wlan::SecurityMode_Wpa2Aes, 0, "123456789012345678901234567890123456789012345678901234567890123" }, true, 10 },
        // AP設定 2-2
        { "2-2", nn::wlan::Ssid(ApSetting2_2_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Open, nn::wlan::SecurityMode_Open, 0, "" }, true, 10 },
        // AP設定 2-3
        { "2-3",nn::wlan::Ssid(ApSetting2_3_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wpa2Aes, nn::wlan::SecurityMode_Wpa2Aes, 0, "AbcdefghijklmnopqrstuvwxyZ" }, true, 10 },
        // AP設定 2-4
        { "2-4", nn::wlan::Ssid(ApSetting2_4_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Open, nn::wlan::SecurityMode_Open, 0, "" }, true, 10 },
        // AP設定 3-1
        { "3-1", nn::wlan::Ssid(ApSetting3_1_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_WpaTkip, nn::wlan::SecurityMode_WpaTkip, 0, "123456789012345678901234567890123456789012345678901234567890123" }, true, 10 },
        // AP設定 4-1
        { "4-1", nn::wlan::Ssid(ApSetting4_1_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wpa2Aes, nn::wlan::SecurityMode_Wpa2Aes, 0, "12345678" }, true, 10 },
        // AP設定 5-1
        { "5-1", nn::wlan::Ssid(ApSetting5_1_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wep64Shared, nn::wlan::SecurityMode_Wep64Shared, 0, "1010101010" }, true, 10 },
        // AP設定 5-2
        { "5-1", nn::wlan::Ssid(ApSetting5_2_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wep128Shared, nn::wlan::SecurityMode_Wep128Shared, 0, "31323334353637383930313233" }, true, 10 },
        // AP設定以外の試験用設定
        // N18 Open
        { "-", nn::wlan::Ssid(wlan_test_1_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Open, nn::wlan::SecurityMode_Open, 0, "" }, true, 10 },
        // N23
        { "5-1", nn::wlan::Ssid(ApSetting5_1_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wep64Shared, nn::wlan::SecurityMode_Wep64Shared, 0, "1010101011" }, true, 10 },
        // N24
        { "5-1", nn::wlan::Ssid(ApSetting5_2_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wep128Shared, nn::wlan::SecurityMode_Wep128Shared, 0, "31323334353637383930313234" }, true, 10 },
        // N26
        { "3-1", nn::wlan::Ssid(ApSetting3_1_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_WpaTkip, nn::wlan::SecurityMode_WpaTkip, 0, "123412341234" }, true, 10 },
        // N28 PASSNG
        { "1-1", nn::wlan::Ssid(ApSetting1_1_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_WpaAes, nn::wlan::SecurityMode_WpaAes, 0, "Passphrase" }, true, 10 },
        // N30
        { "2-3",nn::wlan::Ssid(ApSetting2_3_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wpa2Aes, nn::wlan::SecurityMode_Wpa2Aes, 0, "AbcdefghijklmnopqrstuvwxyZA" }, true, 10 },
        // N32
        { "1-3", nn::wlan::Ssid(ApSetting1_3_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wpa2Aes, nn::wlan::SecurityMode_Wpa2Aes, 0, "12345678" }, true, 10 },
        // N34
        { "-",nn::wlan::Ssid(wlan_test_2_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wpa2Aes, nn::wlan::SecurityMode_Wpa2Aes, 0,
            "012345678901234567890123456789012345678901234567890123456789012" }, true, 10 },
        // N38
        { "1-3", nn::wlan::Ssid("01234567890123456789012345678901"), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wpa2Aes, nn::wlan::SecurityMode_Wpa2Aes, 0, "12345678" }, true, 10 },
        // N40 Open
        { "-", nn::wlan::Ssid(wlan_test_3_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Open, nn::wlan::SecurityMode_Open, 0, "" }, true, 10 },
        // N41 Open
        { "-", nn::wlan::Ssid(wlan_test_4_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Open, nn::wlan::SecurityMode_Open, 0, "" }, true, 10 },
        // N42 Open
        { "-", nn::wlan::Ssid(wlan_test_5_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Open, nn::wlan::SecurityMode_Open, 0, "" }, true, 10 },
        // N54
        { "-", nn::wlan::Ssid(ApSetting2_3_Ssid), nn::wlan::MacAddress(InfraMacAddress), -1,
            { nn::wlan::SecurityMode_Wpa2Aes, nn::wlan::SecurityMode_Wpa2Aes, 0, "AbcdefghijklmnopqrstuvwxyZ" }, true, 10 },
        // N58
        { "1-1", nn::wlan::Ssid(ApSetting1_1_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_WpaAes, nn::wlan::SecurityMode_WpaAes, 0, "Passphrase- [!#$%&'()=^~@;+:*,.<>/?`@\"']|" }, true, 15 },
        // N68
        { "1-4", nn::wlan::Ssid(ApSetting1_4_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Wep128Open, nn::wlan::SecurityMode_Wep128Open, 0, "30313233343536373839616265" }, true, 10 },
        // N123
        { "-", nn::wlan::Ssid("存在しないAP"), nn::wlan::MacAddress::CreateBroadcastMacAddress(), -1,
            { nn::wlan::SecurityMode_Open, nn::wlan::SecurityMode_Open, 0, "123456789012345678901234567890123456789012345678901234567890123" }, true, 10 },
        // N124
        { "1-1", nn::wlan::Ssid(ApSetting1_1_Ssid), nn::wlan::MacAddress::CreateBroadcastMacAddress(), 6,
            { nn::wlan::SecurityMode_WpaAes, nn::wlan::SecurityMode_WpaAes, 6, "Passphrase- [!#$%&'()=^~@;+:*,.<>/?`@\"']|" }, true, 10 },

    };

    enum APKIND
    {
        // AP設定
        AP1_1_WPAAES,
        AP1_2_WEP64,
        AP1_3_WPA2TKIP,
        AP1_4_WEP128,
        AP2_1_WPA2AES,
        AP2_2_OPEN,
        AP2_3_WPA2AES,
        AP2_4_OPEN,
        AP3_1_WPATKIP,
        AP4_1_WPA2AES,
        AP5_1_SHAREDWEP64,
        AP5_2_SHAREDWEP128,
        // AP設定以外の試験用設定
        N18TEST_OPEN,
        N23_SHAREDWEP64,
        N24_SHAREDWEP128,
        N26TEST_WPATKIP,
        N28TEST_WPAPSK_PASSNG,
        N30TEST_WPA2AES,
        N32TEST_WPA2AES,
        N34TEST_WPA2AES,
        N38TEST_WPA2AES,
        N40TEST_OPEN,
        N41TEST_OPEN,
        N42TEST_OPEN,
        N54TEST_OPEN,
        N58TEST_WPAAES,
        N68TEST_PASSNG,
        N123TEST,
        N124TEST,

        APTEST_NUM
    };
    const int ApArrayLen = INET_ADDRSTRLEN + 1;

    struct StringIpv4
    {
        char ipAddress[ApArrayLen];
        char mask[ApArrayLen];
        char gateWay[ApArrayLen];
        char dns1[ApArrayLen];
        char dns2[ApArrayLen];
    };

    const char IPAddr[APTEST_NUM][ApArrayLen] = {
        // AP設定
        {"192.168.11.2"},  // AP1_1
        {"192.168.11.2"},  // AP1_2
        {"192.168.11.2"},  // AP1_3
        {"192.168.11.2"},  // AP1_4
        {"192.168.10.2"},  // AP2_1
        {"192.168.10.2"},  // AP2_2
        {"192.168.10.2"},  // AP2_3
        {"192.168.10.2"},  // AP2_4
        {"192.168.0.2"},   // AP3_1
        {"192.168.11.2"},  // AP4_1
        {"192.168.0.2"},   // AP5_1
        {"192.168.0.2"},   // AP5_2
        // AP設定以外の試験用設定
        {"192.168.11.2"},  // N18
        {"192.168.0.2"},   // N23
        {"192.168.0.2"},   // N24
        {"192.168.10.2"},  // N26
        {"192.168.11.2"},  // N28
        {"192.168.10.2"},  // N30
        {"192.168.11.2"},  // N32
        {"192.168.11.2"},  // N34
        {"192.168.11.2"},  // N38
        {"192.168.11.2"},  // N40
        {"172.31.220.2"},  // N41
        {"172.31.220.2"},  // N42
        {"192.168.11.2"},  // N54
        {"192.168.11.2"},  // N58
        {"192.168.11.2"},  // N68
        {"192.168.10.2"},  // N123
        {"192.168.11.2"},  // N124
    };
    char IpAdder[ApArrayLen] = {0};
    char GWIpAdder[ApArrayLen] = {0};

    enum WowlTestKind
    {
        N131N139_WowlTest = 0,
        N140_WowlMasterTest,
        N140_WowlClientTest,
        WowlTest_Num
    };

    enum WowlTestMsgKind
    {
        N131_WowlTestMsg = 0,
        N132_WowlTestMsg,
        N133_WowlTestMsg,
        N134_WowlTestMsg,
        N135_WowlTestMsg,
        N136_WowlTestMsg,
        N137_WowlTestMsg, // N137未対応で保留
        N138_WowlTestMsg, // N138未対応で保留
        N139_WowlTestMsg,
        N140_WowlTestMsg,
        WowlTestMsg_Num
    };

    StringIpv4 TestSdevIpv4[WowlTest_Num] = {
        { "192.168.10.7", "255.255.255.0", "192.168.10.1", "192.168.10.1", "0.0.0.0" },
        { "192.168.10.7", "255.255.255.0", "192.168.10.1", "192.168.10.1", "0.0.0.0" },
        { "192.168.10.8", "255.255.255.0", "192.168.10.1", "192.168.10.1", "0.0.0.0" },
    };

    static const char* WlanConnectionStateStr[] = {
        "IDLE",
        "CONNECTED",
        "DISCONNECTED",
        "JOINED",
    };

    const char* SecurityTypeString[nn::wlan::SecurityMode_StaticAes + 1] =
    {
        "OPEN",
        "WEP64 OPEN",
        "WEP64 SHARED",
        "WEP128 OPEN",
        "WEP128 SHARED",
        "WPA TKIP",
        "WPA2 TKIP",
        "WPA AES",
        "WPA2 AES",
        "STATIC AES",
    };

    static const char* CipherTypeString[] =
    {
        "USE_GROUPKEY",
        "WEP_40BIT",
        "TKIP",
        "AES_OCB",
        "AES_CCMP",
        "WEP_104BIT",
        "NONE"
    };

    static const char*  AkmTypeString[] =
    {
        "NO_WPA",
        "WPA_EAP",
        "WPA_PSK"
    };

    static const char*  CauseOfInfo[] =
    {
        "NoInfo",
        "NoBss",
        "BeaconLost",
        "DisconnectReq",
        "RecieveDisconnect",
        "ConnectRequest",
        "ConnectFailure",
        "JoinRequest",
        "JoinFailure",
        "ReceiveBcDeauth",
        "DecryptionError",
        "ClientTimeout",
        "Unknown"
    };

    static const char*  LinkLevel[] =
    {
        "LinkLevel_0",
        "LinkLevel_1",
        "LinkLevel_2",
        "LinkLevel_3"
    };

    static const char* WakeupReasonState[] =
    {
        "Nothing",
        "Magic packet",
        "Receive pattern data",
        "Link down",
        "Receive TCP session data"
    };

    const char* WowlTestMsg[WowlTestMsg_Num] = {
        // N131
        "Restart WiFi AP after SDEV Or EDEV WowlSleep State.",
        // N132
        "Power Off WiFi AP after SDEV Or EDEV WowlSleep State." ,
        // N133
        "Send Fin Packet from WowlFunctionTestServer after SDEV Or EDEV WowlSleep State.",
        // N134
        "Send Tcp Data Packet from WowlFunctionTestServer after SDEV Or EDEV WowlSleep State.",
        // N135
        "Send ARP packets from Linux environment arping command after SDEV Or EDEV WowlSleep State."
            "Confirm that ARP packets are sent.",
        // N136
        "After Disconnecting from WowlSleep state of SDEV Or EDEV. "
            "Confirm whether you can receive TCP after getting up.",
        // N137 未対応で保留
        "Tcp Data packet is transmitted 1000 times from WowlFunctionTestServer "
            "after SDEV Or EDEV WowlSleep State. Confirm whether you can receive TCP after getting up.",
        // N138 未対応で保留
        "Tcp Data packet is transmitted 1000 times from WowlFunctionTestServer "
            "after SDEV Or EDEV making go to WowlSleep again in middle of waking up."
            "Confirm whether you can receive TCP after getting up.",
        // N139
        "Joycon Pairing operation Test after SDEV Or EDEV WowlSleep State.",
        // N140
        "Infra to Local Mode Transition Test after SDEV Or EDEV WowlSleep State.",
    };
} // namespace

