﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

class IfInit{
public:
    IfInit();
    ~IfInit();
    void InitializeEtherInterface();
    void FinalizeEtherInterface();

private:
    nn::eth::client::InterfaceGroupHandler*    m_EthernetInterfaceGroup;
    nn::eth::InterfaceList                     m_CurrentInterfaceList;
    nn::os::MultiWaitType                      m_MultiWait;
    nn::os::MultiWaitHolderType                m_InterfaceGroupHolder;
    bool                                       m_Running;
    char                                       m_pStringStorage[16];

    void HandleInterfaceGroupEvent();
    void ConfigureInterface(const char* interfaceName, bool enable, bool useDhcp);
    void HandleInterfaceMediaEvent(nn::os::MultiWaitHolderType* holder);

    // Link group or event handler into multi wait
    template <typename T>
    void SetupWaitHolder(nn::os::MultiWaitHolderType* holder, T* impl)
    NN_NOEXCEPT
    {
        nn::os::InitializeMultiWaitHolder(holder,  reinterpret_cast<nn::os::SystemEventType*>(impl->GetSystemEventPointer()));
        nn::os::SetMultiWaitHolderUserData(holder, reinterpret_cast<uintptr_t>(impl));
        nn::os::LinkMultiWaitHolder(&m_MultiWait, holder);
    }
};

