﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nnt/nntest.h>
#include <nn/util/util_TypedStorage.h>

namespace {

// typedef された型を前方宣言できない場合は継承した型を前方宣言することにより回避します。
typedef nn::util::TypedStorage< struct Impl, 24, 8 > Storage;
Storage g_Storage;

} // anonymous namespace

//--------------------------------------------------------------------------------------------------

namespace {

struct Impl
{
    int64_t padding[ 3 ];
};

static_assert( sizeof( Impl ) == sizeof( Storage ), "Invalid size." );
static_assert( NN_ALIGNOF( Impl ) == NN_ALIGNOF( Storage ), "Invalid alignment." );

} // anonymous namespace

TEST( TypedStorage, Get )
{
    Impl& impl = Get( g_Storage );
    NN_UNUSED( impl );

    const Impl& constImpl = Get( const_cast< const Storage& >( g_Storage ) );
    NN_UNUSED( constImpl );
}
