﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>
#include <glv_viewcontainer.h>

namespace nnt {
namespace usb {

class Stage : public glv::Group
{
    NN_DISALLOW_COPY( Stage );
    NN_DISALLOW_MOVE( Stage );

public:
    explicit Stage(const glv::Rect& rect) NN_NOEXCEPT
        : glv::Group(rect)
    {
        disable(glv::Property::HitTest   |
                glv::Property::DrawBack  |
                glv::Property::DrawBorder);
    }

    ~Stage() NN_NOEXCEPT
    {
    }

    virtual const char *className() const NN_OVERRIDE { return "Stage"; };
};

} // ~usb
} // ~nnt
