﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

#include "widgets/Scene.h"

namespace nnt {
namespace usb {

class SettingsView : public Scene
{
    NN_DISALLOW_COPY( SettingsView );
    NN_DISALLOW_MOVE( SettingsView );

public:
    explicit SettingsView(Stage& stage) NN_NOEXCEPT;

    ~SettingsView() NN_NOEXCEPT;

    virtual const char *className() const { return "SettingsView"; };

private:
    glv::Placer  m_Placer;

    // Log Settings
    glv::Table   m_LogTable;
    glv::Label   m_LogTitle;

    // Cradle Settings
    glv::Table   m_CradleTable;
};

} // ~usb
} // ~nnt
