﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>

#include "UsbDiag_Theme.h"
#include "UsbDiag_LabelView.h"
#include "UsbDiag_UsbModel.h"

namespace nnt {
namespace usb {

LabelView::LabelView(const char   *string,
                     glv::space_t  paddingX,
                     glv::space_t  paddingY,
                     glv::View&    detail) NN_NOEXCEPT
    : m_Detail(detail)
{
    disable(glv::Property::FocusToTop);

    glv::Label *label = new glv::Label(string);

    extent(label->width() + paddingX * 2, label->height() + paddingY * 2);

    *this << label;

    label->pos(glv::Place::CL, paddingX, height() / 2);
    label->anchor(glv::Place::CL);
    label->stretch(0, 0);
}

LabelView::~LabelView() NN_NOEXCEPT
{
    // nothing special
}

bool LabelView::onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT
{
    bool bubble = true;

    switch (e)
    {
    case glv::Event::DebugPadDown:
        {
            const auto& pe = g.getDebugPadEvent();
            if (pe.IsButtonDown<glv::DebugPadEventType::Button::Ok>())
            {
                g_Model.UpdateDetail(m_Detail);
                bubble = false;
            }
        }
        break;

    case glv::Event::BasicPadDown:
        {
            const auto& pe = g.getBasicPadEvent();
            if (pe.IsButtonDown<glv::BasicPadEventType::Button::Ok>())
            {
                g_Model.UpdateDetail(m_Detail);
                bubble = false;
            }
        }
        break;

    case glv::Event::MouseDown:
        g_Model.UpdateDetail(m_Detail);
        bubble = false;
        break;

    default:
        break;
    }

    return bubble;
}

} // ~usb
} // ~nnt
