﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv.h>

#include "UsbDiag_UsbModel.h"
#include "UsbDiag_AdaptiveListView.h"

namespace nnt {
namespace usb {

class IfView : public AdaptiveListView
{
public:
    explicit IfView(const Interface& interface) NN_NOEXCEPT;

    ~IfView() NN_NOEXCEPT;

    virtual const char *className() const { return "IfView"; };

private:
    void CreateDetailView() NN_NOEXCEPT;

    const char *GetClassString(uint8_t code) NN_NOEXCEPT;

private:
    char                 m_String[128];
    const Interface&     m_Interface;

    glv::Table           m_Detail;
};

} // ~usb
} // ~nnt
