﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "UsbDiag_Theme.h"
#include "UsbDiag_UsbModel.h"
#include "UsbDiag_DetailView.h"

using namespace nn::usb;

namespace nnt {
namespace usb {

DetailView::DetailView(const unsigned width, const unsigned height) NN_NOEXCEPT
    : glv::Scroll(glv::Rect(width, height), DetailScrollBarWidth, DetailPaddingX, DetailPaddingY)
{
    disable(glv::Property::DrawBack   |
            glv::Property::HitTest    |
            glv::Property::FocusToTop |
            glv::Property::Animate);

    g_Model.attach(OnUpdateDetail, Event_UpdateDetail, this);
}

DetailView::~DetailView() NN_NOEXCEPT
{
    g_Model.attach(OnUpdateDetail, Event_UpdateDetail, this);
}

void DetailView::OnUpdateDetail(const glv::Notification& n) NN_NOEXCEPT
{
    DetailView *self = n.receiver<DetailView>();
    glv::View *view = const_cast<glv::View*>(n.data<glv::View>());

    if (self->child)
    {
        self->child->remove();
    }

    *self << view;
}

} // ~usb
} // ~nnt
