﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

struct AudioOutArgs
{
    nn::os::SystemEvent* bufferEvent;
    nn::audio::AudioOut* audioOut;
    bool isRunning;
};


struct AudioInArgs
{
    nn::mem::StandardAllocator* allocator;
    int bufferLengthInMilliseconds;
    bool isRunning;
};

enum AudioInEventType
{
    AudioInEventType_Invalid,
    AudioInEventType_Connect,
    AudioInEventType_Disconnect,
    AudioInEventType_Buffer,
};

class AudioInEventData
{
public:
    AudioInEventData()
        : m_Event(nullptr)
        , m_Index(-1)
        , m_Type(0)
        , m_InUse(false)
    {}

    void Acquire(int audioIndex, int eventType, nn::os::SystemEventType* event)
    {
        NN_ASSERT(!m_InUse);
        m_Index = audioIndex;
        m_Type = eventType;
        m_Event = event;
        m_InUse = true;
    }

    void Release()
    {
        NN_ASSERT(m_InUse);
        m_InUse = false;
        m_Index = -1;
        m_Event = nullptr;
        m_Type = AudioInEventType_Invalid;
    }

    int GetIndex()
    {
        return m_Index;
    }

    int GetType()
    {
        return m_Type;
    }

    bool IsInUse()
    {
        return m_InUse;
    }

    void ClearEvent()
    {
        if (m_Event)
        {
            nn::os::ClearSystemEvent(m_Event);
        }
    }
private:
    nn::os::SystemEventType* m_Event;
    int m_Index;
    int m_Type;
    bool m_InUse;
};
