﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Fx3Methods/Fx3.h"

namespace nnt {
namespace usb {
namespace hs {

const Fx3DeviceMode deviceModes[] =
{
    {FX3_DEVICE_FULL_SPEED, FX3_CTRL_MPS_64, FX3_INTERFACE_CTRL | FX3_INTERFACE_BULK_1 | FX3_INTERFACE_BULK_2 | FX3_INTERFACE_INTR_3 | FX3_INTERFACE_INTR_4},
    {FX3_DEVICE_HIGH_SPEED, FX3_CTRL_MPS_64, FX3_INTERFACE_CTRL | FX3_INTERFACE_BULK_1 | FX3_INTERFACE_BULK_2 | FX3_INTERFACE_INTR_3 | FX3_INTERFACE_INTR_4},
    {FX3_DEVICE_SUPER_SPEED, FX3_CTRL_MPS_512, FX3_INTERFACE_CTRL | FX3_INTERFACE_BULK_1 | FX3_INTERFACE_BULK_2 | FX3_INTERFACE_INTR_3 | FX3_INTERFACE_INTR_4},
};

enum
{
    ITERATIONS              = 1,
};

class HsFx3SetInterfaceTest : public ::testing::TestWithParam<Fx3DeviceMode>{};

INSTANTIATE_TEST_CASE_P(DeviceModes, HsFx3SetInterfaceTest, ::testing::ValuesIn(deviceModes));


///////////////////////////////////////////////////////////////////////////////
TEST_P(HsFx3SetInterfaceTest, BulkandIntrSettings)
{
    FX3_LOG("Not testing for bPacketSize0 8, 16, 32. Packet size work around causes descriptor transfers to take too long and fail enumeration\n\n");

    ASSERT_TRUE(IsFx3Initialized());

    for (int i = 0; i < ITERATIONS; i++)
    {
        Fx3DeviceMode fx3DeviceMode;

        fx3DeviceMode.connectSpeed      = GetParam().connectSpeed;
        fx3DeviceMode.maxPacketSize     = GetParam().maxPacketSize;
        fx3DeviceMode.interfaceBitmap   = GetParam().interfaceBitmap;

        Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);

        uint8_t numBulkAltSetting = 0;
        switch (GetParam().connectSpeed)
        {
            case FX3_DEVICE_FULL_SPEED:     numBulkAltSetting = FX3_BULK_ALT_SETTINGS_FS;   break;
            case FX3_DEVICE_HIGH_SPEED:     numBulkAltSetting = FX3_BULK_ALT_SETTINGS_HS;   break;
            case FX3_DEVICE_SUPER_SPEED:    numBulkAltSetting = FX3_BULK_ALT_SETTINGS_SS;   break;
            default:                                                                    break;
        }

        uint8_t numIntrAltSetting = 0;
        switch (GetParam().connectSpeed)
        {
            case FX3_DEVICE_FULL_SPEED:     numIntrAltSetting = FX3_INTR_ALT_SETTINGS_FS;   break;
            case FX3_DEVICE_HIGH_SPEED:     numIntrAltSetting = FX3_INTR_ALT_SETTINGS_HS;   break;
            case FX3_DEVICE_SUPER_SPEED:    numIntrAltSetting = FX3_INTR_ALT_SETTINGS_SS;   break;
            default:                                                                    break;
        }
        // bulk interface
        for (int i = 0; i <= numBulkAltSetting; i++)
        {
            Fx3SetAltSetting(FX3_INTERFACE_NUMBER_BULK_1, i);
            Fx3SetAltSetting(FX3_INTERFACE_NUMBER_BULK_2, i);
        }

        // intr interface
        for (int i = 0; i <= numIntrAltSetting; i++)
        {
            Fx3SetAltSetting(FX3_INTERFACE_NUMBER_INTR_3, i);
            Fx3SetAltSetting(FX3_INTERFACE_NUMBER_INTR_4, i);
        }
    }
}


} // hs
} // usb
} // nnt

