﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Fx3Methods/Fx3.h"

namespace nnt {
namespace usb {
namespace hs {

const Fx3DeviceMode deviceModes[] =
{
    {FX3_DEVICE_FULL_SPEED, FX3_CTRL_MPS_64, FX3_INTERFACE_CTRL},
    {FX3_DEVICE_HIGH_SPEED, FX3_CTRL_MPS_64, FX3_INTERFACE_CTRL},
    {FX3_DEVICE_SUPER_SPEED, FX3_CTRL_MPS_512, FX3_INTERFACE_CTRL},
};

enum
{
    ITERATIONS              = 1,
};

class HsFx3EnumTest : public ::testing::TestWithParam<Fx3DeviceMode>{};

INSTANTIATE_TEST_CASE_P(DeviceModes, HsFx3EnumTest, ::testing::ValuesIn(deviceModes));

///////////////////////////////////////////////////////////////////////////////
TEST_P(HsFx3EnumTest, VariousInterfaces)
{
    ASSERT_TRUE(IsFx3Initialized());

    Fx3DeviceMode fx3DeviceMode;

    fx3DeviceMode.connectSpeed = GetParam().connectSpeed;

    FX3_LOG("Not testing enum with interface 0 for bPacketSize0 8, 16, 32. \n Packet size work around causes descriptor transfers to take too long and larger configuration descriptor will fail enumeration\n\n");

/*
    // bMaxPacketSize 8
    fx3DeviceMode.maxPacketSize = FX3_CTRL_MPS_8;

    for (int i = 0; i < ITERATIONS; i++)
    {
        for (uint8_t interfaceBitmap = 0; interfaceBitmap <= 0xf; interfaceBitmap++)
        {
            fx3DeviceMode.interfaceBitmap = interfaceBitmap;
            Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);
        }
    }

    // bMaxPacketSize 16
    fx3DeviceMode.maxPacketSize = FX3_CTRL_MPS_16;

    for (int i = 0; i < ITERATIONS; i++)
    {
        for (uint8_t interfaceBitmap = 0; interfaceBitmap <= 0xf; interfaceBitmap++)
        {
            fx3DeviceMode.interfaceBitmap = interfaceBitmap;
            Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);
        }
    }

    // bMaxPacketSize 32
    fx3DeviceMode.maxPacketSize = FX3_CTRL_MPS_32;

    for (int i = 0; i < ITERATIONS; i++)
    {
        for (uint8_t interfaceBitmap = 0; interfaceBitmap <= 0xf; interfaceBitmap++)
        {
            fx3DeviceMode.interfaceBitmap = interfaceBitmap;
            Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);
        }
    }
*/
    // bMaxPacketSize 64 for FS/HS, 512 fo SS: See deviceModes
    fx3DeviceMode.maxPacketSize = GetParam().maxPacketSize;

    for (int i = 0; i < ITERATIONS; i++)
    {
        for (uint8_t interfaceBitmap = 0; interfaceBitmap <= 0xf; interfaceBitmap++)
        {
            fx3DeviceMode.interfaceBitmap = interfaceBitmap;
            Fx3SetDeviceMode(&fx3DeviceMode, WAIT_SECONDS_FOR_ATTACH);
        }
    }
}


} // hs
} // usb
} // nnt
