﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nnt.h>
#include <nn/nn_Log.h>
#include <nn/nn_Windows.h>
#include <cstdio>
#include <iostream>

#include "RelayControl.h"
#include "DebugMonitor.h"

int main(int argc, char *argv[])
{
    int programStatus = 0;

    // Default commands
    bool isObserver = false;
    bool isShutdown = false;

    // Parse arguments
    if(argc >= 2)
    {
        const char* pCommand = argv[1];
        isObserver = (strcmp(pCommand, "Observer") == 0) ? true : false;
        isShutdown = (strcmp(pCommand, "Shutdown") == 0) ? true : false;
    }

    if(isObserver)
    {
        if((programStatus=nnt::usb::DoRelayControl(nnt::usb::RelayControlCommand_BootUp)) >= 0)
        {
            // The DebugMonitor program doesn't stop trying upon error, but avoid monopolizing the CPU
            do
            {
                if((programStatus = nnt::usb::InitializeDebugMonitor()) >= 0)
                {
                    // At this time, this does not return unless there is a problem
                    programStatus = nnt::usb::DoDebugMonitor();

                    // Cleanup
                    nnt::usb::FinalizeDebugMonitor();
                }

                if(programStatus < 0)
                {
                    // Backoff for a few seconds
                    Sleep(3000);
                }

            }while(programStatus < 0);
        }
    }
    else if (isShutdown)
    {
        programStatus = nnt::usb::DoRelayControl(nnt::usb::RelayControlCommand_ShutDown);
    }

    return programStatus;
}
