﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>

#include <nn/os.h>
#include <nn/nn_Log.h>

#include <nnt/nntest.h>

#include "uart_CircularBuffer.h"

namespace {

const size_t BufferSize = 1 * nn::os::MemoryPageSize;

NN_STATIC_ASSERT(nn::os::MemoryPageSize == 4096);

// 内部バッファ
NN_ALIGNAS(4096) char s_Buffer[BufferSize];

// テスト用の同じサイズのバッファ
NN_ALIGNAS(4096) char s_TestBuffer[BufferSize];

// CircularBuffer
nn::uart::driver::detail::CircularBuffer      s_CircularBuffer;

}

// CircularBuffer の基本的なテスト
// データの内容はここでは精査せず、ライブラリの Assert にひっかからないことをチェックする
TEST(UartTest, CircularBuffer)
{
    // 初期化
    s_CircularBuffer.Initialize(s_Buffer, BufferSize);

    // 適当な値を書く
    bool wasOverwritten = false;
    char str[] = "0123456789";
    size_t written = s_CircularBuffer.Overwrite(&wasOverwritten, str, 10);

    // テスト用バッファを 0 埋め
    std::memset(s_TestBuffer, 0x00, BufferSize);

    // バッファと同じサイズのデータを書いてみる
    written = s_CircularBuffer.Overwrite(&wasOverwritten, s_TestBuffer, BufferSize);

    // 上書きせずに終端から先頭へいくパターンを試すために半分 + alpha 取り出す
    s_CircularBuffer.Read(s_TestBuffer, BufferSize / 2 + 10);

    // 半分書き込む
    written = s_CircularBuffer.Overwrite(&wasOverwritten, s_TestBuffer, BufferSize / 2);

}

