﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>

#include <nn/cduac/cduac_Spec.h>
#include <nn/cduac/cduac_Api.h>

#include "./UacCommon.h"

//////////////////////////////////////////////////////////////////////////////
static void PrintSampleFreq(nn::cduac::AudioSamplingFrequency *pAudioSamplingFrequency, uint32_t frequency)
{
    pAudioSamplingFrequency->n1         = frequency % 256;
    pAudioSamplingFrequency->n256       = frequency / 256;
    pAudioSamplingFrequency->n65536     = frequency / 65536;
}

enum
{
    NUM_SAMPLE_RATES = 7,
};

void UacSetEndpoint(nn::cduac::Parser *pParser, nn::cduac::Interface *pInterface)
{
    NN_SDK_LOG("%s\n", __FUNCTION__);

    nn::Result result;

    uint32_t sampleFrequency[NUM_SAMPLE_RATES] =
    {
        48000,
        44100,
        24000,
        22050,
        12000,
        11025,
        8000
    };

    nn::usb::UsbEndpointDescriptor *pEndpoint = pParser->GetEndpoint(pInterface->GetInterfaceProfile(), 1, 0);

    if (pEndpoint)
    {
        int i;

        // try to open the highest sample rate on table
        for (i = 0; i < NUM_SAMPLE_RATES; i++)
        {
            nn::cduac::AudioSamplingFrequency audioSamplingFrequency;

            PrintSampleFreq(&audioSamplingFrequency, sampleFrequency[i]);

            result = pInterface->SetEndpointControl(
                                                        nn::cduac::Request_SetCur,
                                                        nn::cduac::Endpoint_SamplingFrequencyControl,
                                                        pEndpoint->bEndpointAddress,
                                                        sizeof(nn::cduac::AudioSamplingFrequency),
                                                        &audioSamplingFrequency
                                                        );

            if (result.IsSuccess())
            {
                NN_SDK_LOG("Sampling Rate set to %d Hz\n", sampleFrequency[i]);
                break;
            }
        }
    }
}

