﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZarfCreatorTest
{
    public static class TestUtil
    {
        public static void ExpectException<T>(Action action) where T : Exception
        {
            var wasThrown = false;
            try
            {
                action();
            }
            catch (T)
            {
                wasThrown = true;
            }
            Assert.IsTrue(wasThrown, "例外が発生しませんでした。");
        }

        public static void ExpectException<T>(Action action, string message) where T : Exception
        {
            var wasThrown = false;
            try
            {
                action();
            }
            catch (T ex)
            {
                StringAssert.Contains(ex.Message, message);
                wasThrown = true;
            }
            Assert.IsTrue(wasThrown, "例外が発生しませんでした。");
        }
    }
}
