﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunnerTest.TestNodeInfoTest
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using TestRunner;

    /// <summary>
    /// [TestRunner.TestNodeInfo]::IsNoPath用のテスト関数を定義します。
    /// </summary>
    [TestClass]
    public class IsNoPathTest
    {
        /// <summary>
        /// 境界値分析: ノードが Path 要素や ProgramName 要素を持たない
        /// </summary>
        [TestMethod]
        public void IsNoPathBoundaryTest001()
        {
            var node = new Dictionary<string, object>();

            IsPathOrNotTest(node, node);
        }

        /// <summary>
        /// 境界値分析: ノード中の Units 要素が Path 要素や ProgramName 要素を持たない
        /// </summary>
        [TestMethod]
        public void IsNoPathBoundaryTest002()
        {
            var parent = new Dictionary<string, object>();

            var child = new Dictionary<string, object>();

            parent["Units"] = new List<object>()
            {
                new Dictionary<string, object>() { { "Path", "valid" } },
                child,
                new Dictionary<string, object>() { { "Path", "valid" } }
            };

            IsPathOrNotTest(child, parent);
        }

        private static void IsPathOrNotTest(Dictionary<string, object> child, Dictionary<string, object> parent)
        {
            child.Clear();

            Assert.IsTrue(new TestNodeInfo(parent).IsNoPath());

            child["Path"] = "value1";

            Assert.IsFalse(new TestNodeInfo(parent).IsNoPath());

            child.Clear();

            child["ProgramName"] = "value2";

            Assert.IsFalse(new TestNodeInfo(parent).IsNoPath());

            child.Clear();

            child["ProgramId"] = "0x0000000000000000";

            Assert.IsFalse(new TestNodeInfo(parent).IsNoPath());

            child["Path"] = "value3";

            Assert.IsFalse(new TestNodeInfo(parent).IsNoPath());
        }
    }
}
