﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundationGeneric.FileFormats.NintendoSdkBinary
{
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.SoundFoundationGeneric.FileFormats.NintendoSdkBinary.WaveSound2Elements;
    using System;
    using System.IO;
    using System.Linq;
    using System.Text;

    [TestClass]
    public class WaveSound2BinaryTest
    {
        [TestMethod]
        public void WriteSingleTrackBinary()
        {
            var binary = new WaveSound2Binary();

            binary.InfoBlock.Body.Tracks.Add(
                this.CreateTestTrackBinary(
                    this.CreateTestClipBinary(0),
                    this.CreateTestClipBinary(1)));

            var buffer = new byte[256];

            using (var writer = new BinaryWriter(new MemoryStream(buffer), Encoding.UTF8, false))
            {
                DomElement binaryElement = new DomBuilder().Build(binary);
                new DomWriter(writer).Run(new DomObjectWriter(), binaryElement);
            }

            // NOTE : とりあえず、例外が起きないことを確認する
        }

        [TestMethod]
        public void WriteMultiTrackBinary()
        {
            var binary = new WaveSound2Binary();

            binary.InfoBlock.Body.Tracks.Add(
                this.CreateTestTrackBinary(this.CreateTestClipBinary(0)));
            binary.InfoBlock.Body.Tracks.Add(
                this.CreateTestTrackBinary(this.CreateTestClipBinary(1)));

            var buffer = new byte[256];

            using (var writer = new BinaryWriter(new MemoryStream(buffer), Encoding.UTF8, false))
            {
                DomElement binaryElement = new DomBuilder().Build(binary);
                new DomWriter(writer).Run(new DomObjectWriter(), binaryElement);
            }

            // NOTE : とりあえず、例外が起きないことを確認する
        }

        private TrackBinary CreateTestTrackBinary(params ClipBinary[] clips)
        {
            var result = new TrackBinary();
            clips.ForEach(clip => result.ClipTable.Items.Add(clip));

            return result;
        }

        private ClipBinary CreateTestClipBinary(int baseValue)
        {
            return new ClipBinary()
            {
                WaveIndex = (ushort)(baseValue + 1),
                Position = (ushort)(baseValue + 2),
                Duration = (ushort)(baseValue + 3),
                StartOffset = (ushort)(baseValue + 4),
                Pitch = (float)(baseValue + 5),
                Volume = (byte)(baseValue + 6),
                Pan = (byte)(baseValue + 7),
            };
        }
    }
}
