﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.ServiceFramework;

namespace Nintendo.ServiceFrameworkTest
{
    [TestClass]
    public class SfNnResultTest
    {
        [TestMethod]
        public void TestCanAccept()
        {
            Assert.IsTrue(SfNnResult.CanAccept(typeof(nn.Result)));
        }

        [TestMethod]
        public void TestGetEntity()
        {
            // 共通テスト
            SfEntityTestUtility.TestGetEntityCommon<nn.Result>();
            // エンティティの型が SfNnResult であることテスト
            var e = typeof(nn.Result).GetSfEntity();
            Assert.AreSame(typeof(SfNnResult), e.GetType());
        }

        [TestMethod]
        public void TestGetReferredTypes()
        {
            var e = typeof(nn.Result).GetSfEntity();
            Assert.AreEqual(0, e.GetReferredEntities().Count());
            Assert.AreEqual(0, e.GetStronglyReferredEntities().Count());
        }
    }
}
