﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Nintendo.ServiceFramework;

namespace Nintendo.ServiceFrameworkTest
{
    public static class SfEntityTestUtility
    {
        public static void TestGetEntityCommon<T>()
        {
            // エンティティの型が SfInterface であることテスト
            var e = typeof(T).GetSfEntity();
            // 同じ型に対して GetEntity した結果が、同じインスタンスであることのテスト
            Assert.AreSame(e, typeof(T).GetSfEntity());
            // System.Type との変換・逆変換結果が同じインスタンスであることのテスト
            Assert.AreSame(typeof(T), (System.Type)(SfEntity)typeof(T));
            Assert.AreSame(e, (SfEntity)(System.Type)e);
        }

        public static void TestGetEntityCommon<T, OtherT>()
        {
            TestGetEntityCommon<T>();
            // 違う型に対して GetEntity した結果が、別の値であることのテスト
            var e = typeof(T).GetSfEntity();
            var e2 = typeof(OtherT).GetSfEntity();
            Assert.AreNotEqual(e, e2);
        }

        public static void TestSizeAndAlignment(int expectedSize, int expectedAlignment, Type type)
        {
            var e = (SfValueType)type.GetSfEntity();
            Assert.AreEqual(expectedSize, e.Size);
            Assert.AreEqual(expectedAlignment, e.Alignment);
        }
    }
}
