﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Nintendo.ServiceFrameworkTest.CppCode
{
    using Nintendo.ServiceFramework.CppCode;

    public static class GenerateTestUtility
    {
        public static void AssertGeneratedString(Action<RawCppCodeGenerator> generate, string expected)
        {
            {
                var b = new StringBuilder();
                using (var w = new StringWriter(b))
                {
                    var g = new RawCppCodeGenerator(w);
                    generate(g);
                    g.Finish();
                }
                Assert.AreEqual(expected, b.ToString());
            }
        }

        public static void AssertGenerateEmpty(Action<RawCppCodeGenerator> generate)
        {
            AssertGeneratedString(generate, string.Empty);
        }
    }
}
