﻿using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.IO;
using PackageCreator;
using System.Linq;

namespace PackageCreatorTest
{
    /// <summary>
    /// WildCardBundleTest の概要の説明
    /// </summary>
    [TestClass]
    public class WildCardBundleTest
    {
        public WildCardBundleTest()
        {
            //
            // TODO: コンストラクター ロジックをここに追加します
            //
        }

        private TestContext testContextInstance;
        private static IEnumerable<string> fileList;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region 追加のテスト属性
        //
        // テストを作成する際には、次の追加属性を使用できます:
        //
        // クラス内で最初のテストを実行する前に、ClassInitialize を使用してコードを実行してください
        [ClassInitialize()]
        public static void MyClassInitialize(TestContext testContext)
        {
            fileList = new[]
            {
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viBuffer\Debug\code\main",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viBuffer\Debug\code\main.npdm",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viBuffer\Debug\code\rtld",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viBuffer\Debug\code\sdk",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viBuffer\Debug\testDisplay_viBuffer.nca",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viBuffer\Debug\testDisplay_viBuffer.nspd_root",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viBuffer\Debug\testDisplay_viBuffer.nspd\**",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testEdid_integration\Debug\code\main",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testEdid_integration\Debug\code\main.npdm",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testEdid_integration\Debug\code\rtld",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDiag_Translation\Release\testDiag_Translation.nspd_root",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDiag_Translation\Release\testDiag_Translation.nspd\**",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDiag_Translation\Release\testDiag_Translation.nss.nssres",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDiag_Translation\Release\testDiag_Translation.nss.res",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viIntegration\Debug\code\main",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viIntegration\Debug\code\main.npdm",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viIntegration\Debug\code\subsdk0",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viIntegration\Debug\code\subsdk1",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viIntegration\Debug\testDisplay_viIntegration.nss.nrsres",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viIntegration\Debug\testDisplay_viIntegration.nss.nssres",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viIntegration\Debug\testDisplay_viIntegration.nss.res",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viStress\Debug\code\sdk",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viStress\Debug\code\subsdk0",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viStress\Debug\testDisplay_viStress.nspd_root",
                @"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viStress\Debug\testDisplay_viStress.nspd\**",
            };
        }
        //
        // クラス内のテストをすべて実行したら、ClassCleanup を使用してコードを実行してください
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // 各テストを実行する前に、TestInitialize を使用してコードを実行してください
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // 各テストを実行した後に、TestCleanup を使用してコードを実行してください
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        [TestMethod]
        public void Recursive()
        {
            var fileGetter = new FileTreeBySpecificFilesImpl(fileList);

            var files = fileGetter.GetFilesForWildCard(@"Tests\Outputs\NX-NXFP2-a32\Tests\testDisp*_*", true).ToList();
            Assert.AreEqual(files.Count, 18);

            files = fileGetter.GetFilesForWildCard(@"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_vi*", true).ToList();
            Assert.AreEqual(files.Count, 18);

            files = fileGetter.GetFilesForWildCard(@"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_v?*", true).ToList();
            Assert.AreEqual(files.Count, 18);

            files = fileGetter.GetFilesForWildCard(@"Tests\Outputs\NX-NXFP2-a32\*\testDis*y_v?*", true).ToList();
            Assert.AreEqual(files.Count, 18);
        }

        [TestMethod]
        public void NotRecursive()
        {
            var fileGetter = new FileTreeBySpecificFilesImpl(fileList);

            var files = fileGetter.GetFilesForWildCard(@"Tests\Outputs\NX-NXFP2-a32\Tests\testDisplay_viBu*\De?ug\code", false).ToList();
            Assert.AreEqual(files.Count, 4);

            files = fileGetter.GetFilesForWildCard(@"Tests\Outputs\NX-NXFP2-a32\*\testDisplay_viBu*\De?ug\code", false).ToList();
            Assert.AreEqual(files.Count, 4);
        }
    }
}
