﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.MakeVisualStudioProject;

namespace Nintendo.MakeVisualStudioProjectTest
{
    [TestClass]
    public class SigloProjectUtilityTest
    {
        [TestMethod]
        public void GetBuildTypeTest()
        {
            Assert.AreEqual("Debug", SigloProjectUtility.GetBuildType("Debug"));
            Assert.AreEqual("Develop", SigloProjectUtility.GetBuildType("Develop"));
            Assert.AreEqual("Release", SigloProjectUtility.GetBuildType("Release"));

            Assert.AreEqual("Debug", SigloProjectUtility.GetBuildType("VS2013_Debug"));
            Assert.AreEqual("Develop", SigloProjectUtility.GetBuildType("VS2015_Develop"));

            Assert.AreEqual("Develop", SigloProjectUtility.GetBuildType("MSVC_Develop"));
            Assert.AreEqual("Release", SigloProjectUtility.GetBuildType("ClangC2_Release"));

            Assert.AreEqual("Debug", SigloProjectUtility.GetBuildType("Generic_Debug"));
            Assert.AreEqual("Develop", SigloProjectUtility.GetBuildType("Cafe_Develop"));

            Assert.AreEqual("Release", SigloProjectUtility.GetBuildType("VS2013_MSVC_Release"));
            Assert.AreEqual("Debug", SigloProjectUtility.GetBuildType("VS2015_ClangC2_Debug"));

            Assert.AreEqual("Develop", SigloProjectUtility.GetBuildType("Generic_VS2013_Develop"));
            Assert.AreEqual("Release", SigloProjectUtility.GetBuildType("Cafe_VS2015_Release"));

            Assert.AreEqual("Debug", SigloProjectUtility.GetBuildType("Generic_MSVC_Debug"));
            Assert.AreEqual("Develop", SigloProjectUtility.GetBuildType("Cafe_ClangC2_Develop"));

            Assert.AreEqual("Release", SigloProjectUtility.GetBuildType("Generic_VS2013_MSVC_Release"));
            Assert.AreEqual("Debug", SigloProjectUtility.GetBuildType("Cafe_VS2015_ClangC2_Debug"));

            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType(""));
            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("Pilot"));

            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("VS2013"));
            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("VS2015_Pilot"));

            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("MSVC"));
            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("ClangC2_Pilot"));

            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("Generic"));
            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("Cafe_Pilot"));

            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("VS2013_MSVC"));
            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("VS2015_ClangC2_Pilot"));

            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("Generic_VS2013"));
            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("Cafe_VS2015_Pilot"));

            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("Generic_MSVC"));
            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("Cafe_ClangC2_Pilot"));

            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("Generic_VS2013_MSVC"));
            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetBuildType("Cafe_VS2015_ClangC2_Pilot"));
        }

        [TestMethod]
        public void GetSpecTest()
        {
            Assert.AreEqual(SigloProjectUtility.DefaultSpec, SigloProjectUtility.GetSpec("Debug"));
            Assert.AreEqual(SigloProjectUtility.DefaultSpec, SigloProjectUtility.GetSpec("Develop"));
            Assert.AreEqual(SigloProjectUtility.DefaultSpec, SigloProjectUtility.GetSpec("Release"));

            Assert.AreEqual(SigloProjectUtility.DefaultSpec, SigloProjectUtility.GetSpec("VS2013_Debug"));
            Assert.AreEqual(SigloProjectUtility.DefaultSpec, SigloProjectUtility.GetSpec("VS2015_Develop"));

            Assert.AreEqual(SigloProjectUtility.DefaultSpec, SigloProjectUtility.GetSpec("MSVC_Develop"));
            Assert.AreEqual(SigloProjectUtility.DefaultSpec, SigloProjectUtility.GetSpec("ClangC2_Release"));

            Assert.AreEqual("Generic", SigloProjectUtility.GetSpec("Generic_Debug"));
            Assert.AreEqual("Cafe", SigloProjectUtility.GetSpec("Cafe_Develop"));

            Assert.AreEqual(SigloProjectUtility.DefaultSpec, SigloProjectUtility.GetSpec("VS2013_MSVC_Release"));
            Assert.AreEqual(SigloProjectUtility.DefaultSpec, SigloProjectUtility.GetSpec("VS2015_ClangC2_Debug"));

            Assert.AreEqual("Generic", SigloProjectUtility.GetSpec("Generic_VS2013_Develop"));
            Assert.AreEqual("Cafe", SigloProjectUtility.GetSpec("Cafe_VS2015_Release"));

            Assert.AreEqual("Generic", SigloProjectUtility.GetSpec("Generic_MSVC_Debug"));
            Assert.AreEqual("Cafe", SigloProjectUtility.GetSpec("Cafe_ClangC2_Develop"));

            Assert.AreEqual("Generic", SigloProjectUtility.GetSpec("Generic_VS2013_MSVC_Release"));
            Assert.AreEqual("Cafe", SigloProjectUtility.GetSpec("Cafe_VS2015_ClangC2_Debug"));
        }

        [TestMethod]
        public void GetVsVersionTest()
        {
            Assert.AreEqual(SigloProjectUtility.DefaultVsVersion, SigloProjectUtility.GetVsVersion("Debug"));
            Assert.AreEqual(SigloProjectUtility.DefaultVsVersion, SigloProjectUtility.GetVsVersion("Develop"));
            Assert.AreEqual(SigloProjectUtility.DefaultVsVersion, SigloProjectUtility.GetVsVersion("Release"));

            Assert.AreEqual("VS2013", SigloProjectUtility.GetVsVersion("VS2013_Debug"));
            Assert.AreEqual("VS2015", SigloProjectUtility.GetVsVersion("VS2015_Develop"));

            Assert.AreEqual(SigloProjectUtility.DefaultVsVersion, SigloProjectUtility.GetVsVersion("MSVC_Develop"));
            Assert.AreEqual(SigloProjectUtility.DefaultVsVersion, SigloProjectUtility.GetVsVersion("ClangC2_Release"));

            Assert.AreEqual(SigloProjectUtility.DefaultVsVersion, SigloProjectUtility.GetVsVersion("Generic_Debug"));
            Assert.AreEqual(SigloProjectUtility.DefaultVsVersion, SigloProjectUtility.GetVsVersion("Cafe_Develop"));

            Assert.AreEqual("VS2013", SigloProjectUtility.GetVsVersion("VS2013_MSVC_Release"));
            Assert.AreEqual("VS2015", SigloProjectUtility.GetVsVersion("VS2015_ClangC2_Debug"));

            Assert.AreEqual("VS2013", SigloProjectUtility.GetVsVersion("Generic_VS2013_Develop"));
            Assert.AreEqual("VS2015", SigloProjectUtility.GetVsVersion("Cafe_VS2015_Release"));

            Assert.AreEqual(SigloProjectUtility.DefaultVsVersion, SigloProjectUtility.GetVsVersion("Generic_MSVC_Debug"));
            Assert.AreEqual(SigloProjectUtility.DefaultVsVersion, SigloProjectUtility.GetVsVersion("Cafe_ClangC2_Develop"));

            Assert.AreEqual("VS2013", SigloProjectUtility.GetVsVersion("Generic_VS2013_MSVC_Release"));
            Assert.AreEqual("VS2015", SigloProjectUtility.GetVsVersion("Cafe_VS2015_ClangC2_Debug"));

            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetVsVersion("Generic_YEAH_MSVC_Debug"));
            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetVsVersion("Cafe_YAY_ClangC2_Develop"));
        }

        [TestMethod]
        public void GetToolsetTest()
        {
            Assert.AreEqual(SigloProjectUtility.DefaultToolset, SigloProjectUtility.GetToolset("Debug"));
            Assert.AreEqual(SigloProjectUtility.DefaultToolset, SigloProjectUtility.GetToolset("Develop"));
            Assert.AreEqual(SigloProjectUtility.DefaultToolset, SigloProjectUtility.GetToolset("Release"));

            Assert.AreEqual(SigloProjectUtility.DefaultToolset, SigloProjectUtility.GetToolset("VS2013_Debug"));
            Assert.AreEqual(SigloProjectUtility.DefaultToolset, SigloProjectUtility.GetToolset("VS2015_Develop"));

            Assert.AreEqual("MSVC", SigloProjectUtility.GetToolset("MSVC_Develop"));
            Assert.AreEqual("ClangC2", SigloProjectUtility.GetToolset("ClangC2_Release"));

            Assert.AreEqual(SigloProjectUtility.DefaultToolset, SigloProjectUtility.GetToolset("Generic_Debug"));
            Assert.AreEqual(SigloProjectUtility.DefaultToolset, SigloProjectUtility.GetToolset("Cafe_Develop"));

            Assert.AreEqual("MSVC", SigloProjectUtility.GetToolset("VS2013_MSVC_Release"));
            Assert.AreEqual("ClangC2", SigloProjectUtility.GetToolset("VS2015_ClangC2_Debug"));

            Assert.AreEqual(SigloProjectUtility.DefaultToolset, SigloProjectUtility.GetToolset("Generic_VS2013_Develop"));
            Assert.AreEqual(SigloProjectUtility.DefaultToolset, SigloProjectUtility.GetToolset("Cafe_VS2015_Release"));

            Assert.AreEqual("MSVC", SigloProjectUtility.GetToolset("Generic_MSVC_Debug"));
            Assert.AreEqual("ClangC2", SigloProjectUtility.GetToolset("Cafe_ClangC2_Develop"));

            Assert.AreEqual("MSVC", SigloProjectUtility.GetToolset("Generic_VS2013_MSVC_Release"));
            Assert.AreEqual("ClangC2", SigloProjectUtility.GetToolset("Cafe_VS2015_ClangC2_Debug"));

            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetToolset("Generic_VS2013_YEAH_Develop"));
            AssertUtility.ThrowsException<ArgumentException>(() => SigloProjectUtility.GetToolset("Cafe_VS2015_YAY_Release"));
        }
    }
}
