﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.MakeVisualStudioProject.Converter;

namespace Nintendo.MakeVisualStudioProjectTest.Converter
{
    [TestClass]
    public class Win32OptionConverterTest
    {
        // TODO: パラメータ化して、サポートする全バージョンでテストを行う
        const string VcToolsVersion = "14.0";
        const string VsVersion = "140";

        [TestMethod]
        public void TestClOptionConversionToItemMetadata()
        {
            var converter = Win32OptionConverter.GetClOptionConverter(VcToolsVersion, VsVersion);
            var testInstances = new Tuple<IEnumerable<string>, IEnumerable<ItemMetadata>, IEnumerable<string>>[]
            {
                new Tuple<IEnumerable<string>, IEnumerable<ItemMetadata>, IEnumerable<string>>(
                    new[] { "/D MACRO1", "/D", "\"MACRO2\"" },
                    new[] { new ItemMetadata("PreprocessorDefinitions", "MACRO1;MACRO2;%(PreprocessorDefinitions)") },
                    new string[0]),
            };

            CheckTestInstances(converter, testInstances);
        }

        [TestMethod]
        public void TestClOptionConversionToOptionString()
        {
            var converter = Win32OptionConverter.GetClOptionConverter(VcToolsVersion, VsVersion);
            var testInstances = new Tuple<IEnumerable<ItemMetadata>, IEnumerable<string>, IEnumerable<ItemMetadata>>[]
            {
                new Tuple<IEnumerable<ItemMetadata>, IEnumerable<string>, IEnumerable<ItemMetadata>>(
                    new[] { new ItemMetadata("PreprocessorDefinitions", "MACRO1;MACRO2;%(PreprocessorDefinitions)") },
                    new[] { "/D \"MACRO1\"", "/D \"MACRO2\"" },
                    new ItemMetadata[0]),
            };

            CheckTestInstances(converter, testInstances);
        }

        [TestMethod]
        public void TestLibOptionConversionToItemMetadata()
        {
            var converter = Win32OptionConverter.GetLibOptionConverter(VcToolsVersion, VsVersion);
            var testInstances = new Tuple<IEnumerable<string>, IEnumerable<ItemMetadata>, IEnumerable<string>>[]
            {
            };

            CheckTestInstances(converter, testInstances);
        }

        [TestMethod]
        public void TestLibOptionConversionToOptionString()
        {
            var converter = Win32OptionConverter.GetLibOptionConverter(VcToolsVersion, VsVersion);
            var testInstances = new Tuple<IEnumerable<ItemMetadata>, IEnumerable<string>, IEnumerable<ItemMetadata>>[]
            {
            };

            CheckTestInstances(converter, testInstances);
        }

        [TestMethod]
        public void TestLinkOptionConversionToItemMetadata()
        {
            var converter = Win32OptionConverter.GetLinkOptionConverter(VcToolsVersion, VsVersion);
            var testInstances = new Tuple<IEnumerable<string>, IEnumerable<ItemMetadata>, IEnumerable<string>>[]
            {
                new Tuple<IEnumerable<string>, IEnumerable<ItemMetadata>, IEnumerable<string>>(
                    new[] { "/MANIFESTUAC:\"level='asInvoker' uiAccess='true'\"" },
                    new[] { new ItemMetadata("EnableUAC", "true"), new ItemMetadata("UACExecutionLevel", "AsInvoker"), new ItemMetadata("UACUIAccess", "true") },
                    new string[0]),
                new Tuple<IEnumerable<string>, IEnumerable<ItemMetadata>, IEnumerable<string>>(
                    new[] { "/MANIFESTUAC:NO" },
                    new[] { new ItemMetadata("EnableUAC", "false") },
                    new string[0]),
            };

            CheckTestInstances(converter, testInstances);
        }

        [TestMethod]
        public void TestLinkOptionConversionToOptionString()
        {
            var converter = Win32OptionConverter.GetLinkOptionConverter(VcToolsVersion, VsVersion);
            var testInstances = new Tuple<IEnumerable<ItemMetadata>, IEnumerable<string>, IEnumerable<ItemMetadata>>[]
            {
                new Tuple<IEnumerable<ItemMetadata>, IEnumerable<string>, IEnumerable<ItemMetadata>>(
                    new[] { new ItemMetadata("EnableUAC", "true"), new ItemMetadata("UACExecutionLevel", "AsInvoker"), new ItemMetadata("UACUIAccess", "true") },
                    new[] { "/MANIFESTUAC:\"level='asInvoker' uiAccess='true'\"" },
                    new ItemMetadata[0]),
                new Tuple<IEnumerable<ItemMetadata>, IEnumerable<string>, IEnumerable<ItemMetadata>>(
                    new[] { new ItemMetadata("EnableUAC", "false") },
                    new[] { "/MANIFESTUAC:NO" },
                    new ItemMetadata[0]),
            };

            CheckTestInstances(converter, testInstances);
        }

        private void CheckTestInstances(
            Win32OptionConverter converter, IEnumerable<Tuple<IEnumerable<string>, IEnumerable<ItemMetadata>, IEnumerable<string>>> testInstances)
        {
            foreach (var testInstance in testInstances)
            {
                var input = testInstance.Item1;
                var expected = testInstance.Item2;
                var expectedUnknowns = testInstance.Item3;

                IEnumerable<string> actualUnknowns;
                var actual = converter.ConvertToItemMetadata(input, out actualUnknowns);

                Assert.IsTrue(
                    actual.SequenceEqual(expected),
                    "expected = {0}, actual = {1}",
                    Utility.ToArrayString(expected),
                    Utility.ToArrayString(actual));
                Assert.IsFalse(
                    actualUnknowns.Any(),
                    "expected = {0}, actual = {1}",
                    Utility.ToArrayString(expectedUnknowns),
                    Utility.ToArrayString(actualUnknowns));
            }
        }

        private void CheckTestInstances(
            Win32OptionConverter converter, IEnumerable<Tuple<IEnumerable<ItemMetadata>, IEnumerable<string>, IEnumerable<ItemMetadata>>> testInstances)
        {
            foreach (var testInstance in testInstances)
            {
                var input = testInstance.Item1;
                var expected = testInstance.Item2;
                var expectedUnknowns = testInstance.Item3;

                IEnumerable<ItemMetadata> actualUnknowns;
                var actual = converter.ConvertToOptionString(input, out actualUnknowns);

                Assert.IsTrue(
                    actual.SequenceEqual(expected),
                    "expected = {0}, actual = {1}",
                    Utility.ToArrayString(expected),
                    Utility.ToArrayString(actual));
                Assert.IsFalse(
                    actualUnknowns.Any(),
                    "expected = {0}, actual = {1}",
                    Utility.ToArrayString(expectedUnknowns),
                    Utility.ToArrayString(actualUnknowns));
            }
        }
    }
}
