﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Nintendo.MakeSampleSolutionTest
{
    static class AssertUtil
    {
        public static void ExpectException<T>(Action a) where T : Exception
        {
            try
            {
                a();
            }
            catch (T)
            {
                return;
            }
            catch (Exception ex)
            {
                Assert.Fail($"{typeof(T)} 型の例外を期待しましたが、{ex.GetType()} 型の例外が送出されました");
            }
            Assert.Fail($"{typeof(T)} 型の例外が送出されませんでした");
        }
    }
}
