﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;
using TestUtility;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace MakeDescTest
{
    public class XmlElement
    {
        private string Name;
        private const string DefaultIndent = "    ";

        public string InnerText { get; set; }

        private List<XmlElement> ChildList;

        public static XmlElement Convert(string xmlTag)
        {
            Regex tagNameRegex = new Regex(@"<([^<>]+)>(.*?)</\1>", RegexOptions.Singleline);
            MatchCollection mc = tagNameRegex.Matches(xmlTag);
            Assert.IsTrue(mc.Count == 1);

            Match m = mc[0];

            XmlElement elem = new XmlElement(m.Groups[1].Value);
            elem.InnerText = m.Groups[2].Value;

            return elem;
        }

        public XmlElement(string name)
        {
            this.Name = name;
            ChildList = new List<XmlElement>();
        }

        public string GetXml(int indentLevel = 0)
        {
            string indent = string.Empty;
            for (int i = 0; i < indentLevel; i++)
            {
                indent += DefaultIndent;
            }

            if (ChildList.Count > 0)
            {
                string result = string.Format("{0}<{1}>{2}", indent, Name, System.Environment.NewLine);
                foreach (var child in ChildList)
                {
                    result += child.GetXml(indentLevel + 1) + System.Environment.NewLine;
                }
                result += string.Format("{0}</{1}>", indent, Name);
                return result;
            }
            else
            {
                return string.Format("{0}<{1}>{2}</{1}>", indent, Name, InnerText);
            }
        }

        public void AddChild(XmlElement elem)
        {
            ChildList.Add(elem);
        }

        public void RemoveChild(string tagName)
        {
            List<XmlElement> delList = new List<XmlElement>();
            foreach (var child in ChildList)
            {
                if (child.Name == tagName)
                {
                    delList.Add(child);
                }
            }

            foreach (var child in delList)
            {
                ChildList.Remove(child);
            }
        }
    }

    public class XmlFile : FileManager
    {
        public const string XmlDeclaration = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        public XmlFile()
        {
            AddLine(XmlDeclaration);
        }
    }
}
