﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Diagnostics;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace MakeDataDocumentTest
{
    public class TestPath
    {
        public TestPath(TestContext testContext)
        {
            Assert.IsNotNull(testContext);
            TestContext = testContext;
        }

        private const string SigloRootMarkFileName = "SigloRootMark";
        private const string TestRootPath = "Tests";
        private const string ToolTestRootPath = "Tests/Tools";
        private const string ResourceDirectoryName = "Resources";

        public string GetSigloRoot()
        {
            return FindSigloRoot(System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location));
        }

        public string FindSigloRoot(string path)
        {
            string startPath = path;
            string currentDirectory = startPath;
            string rootDirectory = Path.GetPathRoot(currentDirectory);

            while (rootDirectory != currentDirectory)
            {
                string sigloRootMarkFilePath = System.IO.Path.Combine(currentDirectory, SigloRootMarkFileName);
                if (System.IO.File.Exists(sigloRootMarkFilePath))
                {
                    return currentDirectory;
                }

                currentDirectory = System.IO.Path.GetFullPath(System.IO.Path.Combine(currentDirectory, ".."));
            }

            throw new InvalidDataException(string.Format("SigloRootMark を見つけられませんでした。\nPath=\n{0}", startPath));
        }

        public string GetTestRoot()
        {
            return Path.Combine(GetSigloRoot(), TestRootPath);
        }

        /// <summary>
        /// テスト出力ディレクトリの取得
        ///
        /// 今は TestContext.TestRunDirectory を返すだけの実装です。
        /// 将来的に適切な出力ファイルの構成を整える可能性があります。
        /// </summary>
        /// <returns></returns>
        public string GetOutputRoot()
        {
            return TestContext.TestRunDirectory;
        }

        public string GetToolTestResourceDirectory()
        {
            return Path.Combine(GetSigloRoot(), ToolTestRootPath, ResourceDirectoryName);
        }

        private TestContext TestContext;
    }
}
