﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text.RegularExpressions;
using GitExternalStorage;
using GitExternalStorage.Git;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using TestUtility;

namespace GitExternalStorageTest
{
    [TestClass]
    public class UnitTestGitRepositoryCommand : UnitTestGitRepositoryBase
    {
        public const string RepositoryPath = "UnitTestGitRepositoryCommand.repo";

        public override string GetRepositoryPath()
        {
            return RepositoryPath;
        }

        public override GitRepositoryBase GetGitRepositoryInstance(string workingDirectory)
        {
            return new GitRepositoryCommand(workingDirectory);
        }

        [ClassInitialize]
        public static void ClassInitialize(TestContext testCotext)
        {
            Directory.CreateDirectory(RepositoryPath);
        }

        [ClassCleanup]
        public static void ClassCleanup()
        {
            Directory.Delete(RepositoryPath, true);
        }
    }
}
