﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Linq;
using System.Text.RegularExpressions;
using GitExternalRepository;
using GitExternalRepository.Extensions;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Microsoft.Win32;
using System.Collections.Generic;
using System.Collections;

namespace GitExternalRepositoryTest
{
    /// <summary>
    /// StringExtensions クラスをテストします。
    /// </summary>
    [TestClass]
    public class UnitTestStringExtensions
    {
        /// <summary>
        /// TrimSlash メソッドを試します。
        /// </summary>
        [TestMethod]
        public void TestTrimSlash()
        {
            {
                var value = "path/to/directory/".TrimSlash();
                var expected = "path/to/directory";

                Assert.AreEqual(expected, value);
            }

            {
                var value = "path/to/directory//".TrimSlash();
                var expected = "path/to/directory";

                Assert.AreEqual(expected, value);
            }

            {
                var value = "path/to/directory\\".TrimSlash();
                var expected = "path/to/directory";

                Assert.AreEqual(expected, value);
            }

            {
                var value = "path/to/directory/\\".TrimSlash();
                var expected = "path/to/directory";

                Assert.AreEqual(expected, value);
            }
        }
    }
}
