﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Nintendo.FsAccessLogChecker;
using Nintendo.FsAccessLogAnalysis;

namespace FsAccessLogCheckerTest
{
    [TestClass]
    public class FsAccessLogCheckerUnitTest
    {
        [TestInitialize]
        public void TestInitialize()
        {
            FsAccessLogCheckerTestUtility.Initialize();
        }

        [TestMethod]
        public void TestFormatTime()
        {
            Assert.AreEqual("1 minutes", MessageFormat.FormatTime((long)(new TimeSpan(0, 1, 1).TotalMilliseconds)));
            Assert.AreEqual("80 minutes", MessageFormat.FormatTime((long)(new TimeSpan(1, 20, 22).TotalMilliseconds)));
            Assert.AreEqual("120 minutes", MessageFormat.FormatTime((long)(new TimeSpan(2, 0, 0).TotalMilliseconds)));
            Assert.AreEqual("9 minutes", MessageFormat.FormatTime(10 * 60 * 1000 - 1));
            Assert.AreEqual("59 seconds", MessageFormat.FormatTime(59 * 1000));
        }

        [TestMethod]
        public void TestFormatTotalMinutes()
        {
            Assert.AreEqual("1 minutes", MessageFormat.FormatTotalMinutes((long)(new TimeSpan(0, 1, 1).TotalMilliseconds)));
            Assert.AreEqual("80 minutes", MessageFormat.FormatTotalMinutes((long)(new TimeSpan(1, 20, 22).TotalMilliseconds)));
            Assert.AreEqual("120 minutes", MessageFormat.FormatTotalMinutes((long)(new TimeSpan(2, 0, 0).TotalMilliseconds)));
            Assert.AreEqual("9 minutes", MessageFormat.FormatTotalMinutes(10 * 60 * 1000 - 1));
        }
    }
}
