﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.Foundation.Primitives;
using EffectMaker.UIControls.Specifics;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test.EffectMaker.UIControls.UnitTests
{
    /// <summary>
    /// test class for vector.
    /// </summary>
    [TestClass]
    public class PrimitvesEqualTest
    {
        /// <summary>
        /// ループの数.
        /// </summary>
        private static int loopCnt = 1 * 1000;

        /// <summary>
        /// simple test.
        /// </summary>
        [TestMethod]
        public void TestSimplePrimitiveEqual1()
        {
            var testValue0 = new Vector3i(3, 2, 1);
            var verifyValue = new Vector3i(1, 2, 3);
            Assert.IsFalse(testValue0.Equals(verifyValue), "Failed");

            testValue0 = new Vector3i(0, 2, 1);
            verifyValue = new Vector3i(0, 1, 2);
            Assert.IsFalse(testValue0.Equals(verifyValue), "Failed");

            testValue0 = new Vector3i(1, 2, 3);
            verifyValue = new Vector3i(1, 2, 3);
            Assert.IsTrue(testValue0.Equals(verifyValue), "Failed");
        }

        #region double

        /// <summary>
        /// Vector1d.
        /// </summary>
        [TestMethod]
        public void TestEqualVector1d()
        {
            Vector1d v0 = new Vector1d(), v1 = new Vector1d();
            Random rnd = new System.Random(Environment.TickCount);

            for (int i = 0; i < loopCnt; i++)
            {
                v0.X = ((rnd.NextDouble() * 2.0) - 1.0) * double.MaxValue;
                v1.X = ((rnd.NextDouble() * 2.0) - 1.0) * double.MaxValue;

                if (v0.X == v1.X)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }
            }
        }

        /// <summary>
        /// Vector2d.
        /// </summary>
        [TestMethod]
        public void TestEqualVector2d()
        {
            Vector2d v0 = new Vector2d(), v1 = new Vector2d();
            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = ((rnd.NextDouble() * 2.0) - 1.0) * double.MaxValue;
                    v1[i] = ((rnd.NextDouble() * 2.0) - 1.0) * double.MaxValue;
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector2d;
                var v3 = v0.Clone() as Vector2d;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }

                v2 = v1.Clone() as Vector2d;
                v3 = v1.Clone() as Vector2d;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }
            }
        }

        /// <summary>
        /// Vector3d.
        /// </summary>
        [TestMethod]
        public void TestEqualVector3d()
        {
            Vector3d v0 = new Vector3d(), v1 = new Vector3d();
            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = ((rnd.NextDouble() * 2.0) - 1.0) * double.MaxValue;
                    v1[i] = ((rnd.NextDouble() * 2.0) - 1.0) * double.MaxValue;
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector3d;
                var v3 = v0.Clone() as Vector3d;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }

                v2 = v1.Clone() as Vector3d;
                v3 = v1.Clone() as Vector3d;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }
            }
        }

        /// <summary>
        /// Vector4d.
        /// </summary>
        [TestMethod]
        public void TestEqualVector4d()
        {
            Vector4d v0 = new Vector4d(), v1 = new Vector4d();
            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = ((rnd.NextDouble() * 2.0) - 1.0) * double.MaxValue;
                    v1[i] = ((rnd.NextDouble() * 2.0) - 1.0) * double.MaxValue;
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector4d;
                var v3 = v0.Clone() as Vector4d;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }

                v2 = v1.Clone() as Vector4d;
                v3 = v1.Clone() as Vector4d;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }
            }
        }

        #endregion // double

        #region float

        /// <summary>
        /// Vector1f.
        /// </summary>
        [TestMethod]
        public void TestEqualVector1f()
        {
            Vector1f v0 = new Vector1f(), v1 = new Vector1f();
            Random rnd = new System.Random(Environment.TickCount);

            for (int i = 0; i < loopCnt; i++)
            {
                v0.X = (float)((rnd.NextDouble() * 2.0) - 1.0) * float.MaxValue;
                v1.X = (float)((rnd.NextDouble() * 2.0) - 1.0) * float.MaxValue;

                if (v0.X == v1.X)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }
            }
        }

        /// <summary>
        /// Vector2f.
        /// </summary>
        [TestMethod]
        public void TestEqualVector2f()
        {
            var v0 = new Vector2f(10.0f, -10.0f);
            var v1 = new Vector2f(-10.0f, 10.0f);

            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = (float)((rnd.NextDouble() * 2.0) - 1.0) * float.MaxValue;
                    v1[i] = (float)((rnd.NextDouble() * 2.0) - 1.0) * float.MaxValue;
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector2f;
                var v3 = v0.Clone() as Vector2f;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }

                v2 = v1.Clone() as Vector2f;
                v3 = v1.Clone() as Vector2f;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }
            }
        }

        /// <summary>
        /// Vector3f.
        /// </summary>
        [TestMethod]
        public void TestEqualVector3f()
        {
            Vector3f v0 = new Vector3f(), v1 = new Vector3f();
            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = (float)((rnd.NextDouble() * 2.0) - 1.0) * float.MaxValue;
                    v1[i] = (float)((rnd.NextDouble() * 2.0) - 1.0) * float.MaxValue;
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector3f;
                var v3 = v0.Clone() as Vector3f;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }

                v2 = v1.Clone() as Vector3f;
                v3 = v1.Clone() as Vector3f;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }
            }
        }

        /// <summary>
        /// Vector4f.
        /// </summary>
        [TestMethod]
        public void TestEqualVector4f()
        {
            Vector4f v0 = new Vector4f(), v1 = new Vector4f();
            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = (float)((rnd.NextDouble() * 2.0) - 1.0) * float.MaxValue;
                    v1[i] = (float)((rnd.NextDouble() * 2.0) - 1.0) * float.MaxValue;
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector4f;
                var v3 = v0.Clone() as Vector4f;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }

                v2 = v1.Clone() as Vector4f;
                v3 = v1.Clone() as Vector4f;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }
            }
        }

        #endregion // float

        #region int

        /// <summary>
        /// Vector1i.
        /// </summary>
        [TestMethod]
        public void TestEqualVector1i()
        {
            Vector1i v0 = new Vector1i(), v1 = new Vector1i();
            Random rnd = new System.Random(Environment.TickCount);

            for (int i = 0; i < loopCnt; i++)
            {
                v0.X = rnd.Next(int.MinValue, int.MaxValue);
                v1.X = rnd.Next(int.MinValue, int.MaxValue);

                if (v0.X == v1.X)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }
            }
        }

        /// <summary>
        /// Vector2i.
        /// </summary>
        [TestMethod]
        public void TestEqualVector2i()
        {
            Vector2i v0 = new Vector2i(10, -10), v1 = new Vector2i();
            v0.GetHashCode();
            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = rnd.Next(int.MinValue, int.MaxValue);
                    v1[i] = rnd.Next(int.MinValue, int.MaxValue);
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector2i;
                var v3 = v0.Clone() as Vector2i;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }

                v2 = v1.Clone() as Vector2i;
                v3 = v1.Clone() as Vector2i;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }
            }
        }

        /// <summary>
        /// Vector3i.
        /// </summary>
        [TestMethod]
        public void TestEqualVector3i()
        {
            var v0 = new Vector3i();
            var v1 = new Vector3i();

            // ランダムの値
            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = rnd.Next(int.MinValue, int.MaxValue);
                    v1[i] = rnd.Next(int.MinValue, int.MaxValue);
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector3i;
                var v3 = v0.Clone() as Vector3i;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }

                v2 = v1.Clone() as Vector3i;
                v3 = v1.Clone() as Vector3i;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }
            }
        }

        /// <summary>
        /// Vector4i.
        /// </summary>
        [TestMethod]
        public void TestEqualVector4i()
        {
            Vector4i v0 = new Vector4i(), v1 = new Vector4i();
            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = rnd.Next(int.MinValue, int.MaxValue);
                    v1[i] = rnd.Next(int.MinValue, int.MaxValue);
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector4i;
                var v3 = v0.Clone() as Vector4i;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }

                v2 = v1.Clone() as Vector4i;
                v3 = v1.Clone() as Vector4i;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }
            }
        }

        #endregion // int

        #region uint

        /// <summary>
        /// Vector1u.
        /// </summary>
        [TestMethod]
        public void TestEqualVector1u()
        {
            Vector1u v0 = new Vector1u(), v1 = new Vector1u();
            Random rnd = new System.Random(Environment.TickCount);

            for (int i = 0; i < loopCnt; i++)
            {
                v0.X = (uint)rnd.Next();
                v1.X = (uint)rnd.Next();

                if (v0.X == v1.X)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }
            }
        }

        /// <summary>
        /// Vector2u.
        /// </summary>
        [TestMethod]
        public void TestEqualVector2u()
        {
            Vector2u v0 = new Vector2u(), v1 = new Vector2u();
            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = (uint)rnd.Next();
                    v1[i] = (uint)rnd.Next();
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector2u;
                var v3 = v0.Clone() as Vector2u;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(v2.GetHashCode() != v3.GetHashCode(), "Failed");
                }

                v2 = v1.Clone() as Vector2u;
                v3 = v1.Clone() as Vector2u;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(v2.GetHashCode() != v3.GetHashCode(), "Failed");
                }
            }
        }

        /// <summary>
        /// Vector3u.
        /// </summary>
        [TestMethod]
        public void TestEqualVector3u()
        {
            Vector3u v0 = new Vector3u(), v1 = new Vector3u();
            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = (uint)rnd.Next();
                    v1[i] = (uint)rnd.Next();
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector3u;
                var v3 = v0.Clone() as Vector3u;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }

                v2 = v1.Clone() as Vector3u;
                v3 = v1.Clone() as Vector3u;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }
            }
        }

        /// <summary>
        /// Vector4u.
        /// </summary>
        [TestMethod]
        public void TestEqualVector4u()
        {
            Vector4u v0 = new Vector4u(), v1 = new Vector4u();
            Random rnd = new System.Random(Environment.TickCount);

            for (int count = 0; count < loopCnt; ++count)
            {
                for (int i = 0; i < v0.Count; ++i)
                {
                    v0[i] = (uint)rnd.Next();
                    v1[i] = (uint)rnd.Next();
                }

                bool isSameValues = true;
                for (int i = 0; i < v0.Count; ++i)
                {
                    if (v0[i] != v1[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == true)
                {
                    Assert.IsTrue(v0.GetHashCode() == v1.GetHashCode(), "Failed");
                }
                else
                {
                    Assert.IsTrue(v0.GetHashCode() != v1.GetHashCode(), "Failed");
                }

                var v2 = v0.Clone() as Vector4u;
                var v3 = v0.Clone() as Vector4u;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }

                v2 = v1.Clone() as Vector4u;
                v3 = v1.Clone() as Vector4u;
                for (int i = 0; i < v3.Count / 2; ++i)
                {
                    var t = v3[i];
                    v3[i] = v3[v3.Count - i - 1];
                    v3[v3.Count - i - 1] = t;
                }

                isSameValues = true;
                for (int i = 0; i < v2.Count; ++i)
                {
                    if (v2[i] != v3[i])
                    {
                        isSameValues = false;
                        break;
                    }
                }

                if (isSameValues == false)
                {
                    Assert.IsTrue(
                        v2.GetHashCode() != v3.GetHashCode(),
                        "Failed:[{0}],[{1}], {2}, {3}",
                        v2.ToString(),
                        v3.ToString(),
                        v2.GetHashCode(),
                        v3.GetHashCode());
                }
            }
        }

        #endregion // uint
    }
}
