﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Globalization;
using System.IO;
using System.Reflection;
using System.Resources;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using EffectMaker.Foundation.Utility;
using EffectMaker.UIControls;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Extensions;
using EffectMaker.UIControls.Localization;
using EffectMaker.UIControls.Xaml;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.EffectMaker.UIControls.TestTypes;

namespace Test.EffectMaker.UIControls.UnitTests
{
    /// <summary>
    /// Test class that contains the localize test methods.
    /// This class mainly tests the Translate class.
    /// </summary>
    [TestClass]
    public class LocalizationUnitTests
    {
        /// <summary>
        /// XAMLのローカライズ機能テスト (英語)。
        /// </summary>
        [TestMethod]
        public void TestLocalization01()
        {
            // 言語を英語に設定
            Thread.CurrentThread.CurrentUICulture = CultureInfo.CreateSpecificCulture("en-US");

            IControl rootControl = null;

            try
            {
                // XAMLリソースを読み込む
                rootControl = (IControl)XamlHelper.LoadControl("test_localization.xaml");
            }
            catch (Exception ex)
            {
                throw new Exception("Failed to load XAML.", ex);
            }

            var flattenTree = rootControl.FlattenControlTree();

            var label1 = (UILabel)flattenTree["label1"];

            if (label1.Text != "English")
            {
                throw new Exception();
            }

            var label2 = (UILabel)flattenTree["label2"];

            if (label2.Text != "The quick brown fox...")
            {
                throw new Exception();
            }

            var label3 = (UILabel)flattenTree["label3"];

            if (label3.Text != "<TEST_LOCALIZATION_ERROR>")
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// XAMLのローカライズ機能テスト (日本語)。
        /// </summary>
        [TestMethod]
        public void TestLocalization02()
        {
            // 言語を日本語に設定
            Thread.CurrentThread.CurrentUICulture = CultureInfo.CreateSpecificCulture("ja-JP");

            // XAMLリソースを読み込む
            var rootControl = (IControl)XamlHelper.LoadControl("test_localization.xaml");
            var flattenTree = rootControl.FlattenControlTree();

            var label1 = (UILabel)flattenTree["label1"];

            if (label1.Text != "日本語")
            {
                throw new Exception();
            }

            var label2 = (UILabel)flattenTree["label2"];

            if (label2.Text != "すばしっこい茶色の狐...")
            {
                throw new Exception();
            }

            var label3 = (UILabel)flattenTree["label3"];

            if (label3.Text != "<TEST_LOCALIZATION_ERROR>")
            {
                throw new Exception();
            }
        }
    }
}
