﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Manager;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace Test.EffectMaker.UIControls.UnitTests
{
    /// <summary>
    /// DataModelManagerのテスト
    /// </summary>
    [TestClass]
    public class DataModelManagerTests
    {
        /// <summary>
        /// DataModelManagerのテスト
        /// </summary>
        [TestMethod]
        public void TestDataModel01()
        {
            object result;
            Assert.IsTrue(
                DataModelManager.GetDataModelDefaultValue(
                typeof(ViewerCameraViewProjectionData), "AspectRatio", out result),
                "Failed");

            Assert.IsTrue(result is float, "Failed");

            Assert.AreEqual(result, 1.66f, "Failed");

            // imageFilePath=デフォルトでnull
            Assert.IsTrue(
                DataModelManager.GetDataModelDefaultValue(
                typeof(ViewerBackgroundImageData), "ImageFilePath", out result),
                "Failed");
            Assert.IsTrue(string.IsNullOrEmpty(result as string), "Failed");
        }

        /// <summary>
        /// DataModelManagerのテスト2
        /// </summary>
        [TestMethod]
        public void TestDataModel02()
        {
            object result;

            // メンバー変数の値は取得できない
            Assert.IsFalse(
                DataModelManager.GetDataModelDefaultValue(
                typeof(ViewerBackgroundColorData), "clearColor", out result),
                "Failed");

            // プロパティ値の取得
            Assert.IsTrue(
                DataModelManager.GetDataModelDefaultValue(
                typeof(ViewerBackgroundColorData), "ClearColor", out result),
                "Failed");

            // 型のチェック
            Assert.IsTrue(result is ColorRgba, "Failed");

            var clearColor = result as ColorRgba;
            var verifyValue = new ColorRgba(1.0f, 1.0f, 1.0f, 1.0f);

            // 個々の成分を比較
            Assert.AreEqual(clearColor.R, verifyValue.R, "Failed");
            Assert.AreEqual(clearColor.G, verifyValue.G, "Failed");
            Assert.AreEqual(clearColor.B, verifyValue.B, "Failed");
            Assert.AreEqual(clearColor.A, verifyValue.A, "Failed");

            // 比較メソッドでチェック
////            Assert.IsTrue(clearColor.IsEqual(verifyValue), "Failed");
            Assert.IsTrue(clearColor.Equals(verifyValue), "Failed");
        }
    }
}
