﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.Foundation.Utility;
using EffectMaker.UIControls.Xaml;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// Class containing helper method related to XAML.
    /// </summary>
    public static class XamlHelper
    {
        /// <summary>
        /// Loads a control from a XAML file using a name relative to the executable directory.
        /// </summary>
        /// <param name="relativeResourceName">Relative XAML resource name.</param>
        /// <returns>Returns a control, or throws an exception.</returns>
        public static Control LoadControl(string relativeResourceName)
        {
            Control control;

            var assembly = Assembly.GetExecutingAssembly();

            using (Stream stream = ResourceUtility.LoadEmbedded(assembly, relativeResourceName))
            {
                control = XamlLoader.Load(stream);
            }

            return control;
        }
    }
}
