﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using EffectMaker.UIControls;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.Extensions;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// An IItemContainerSelector for test purpose only.
    /// </summary>
    public class TestItemContainerSelector : IItemContainerSelector
    {
        /// <summary>
        /// Select an item container for a given data item.
        /// </summary>
        /// <param name="dataItem">Data item.</param>
        /// <returns>Returns a item container control.</returns>
        public IControl SelectItemContainer(object dataItem)
        {
            if (dataItem is DateTime)
            {
                var dtp = new UIDateTimePicker();
                dtp.AddBinding("Value", null);
                return dtp;
            }
            else
            {
                var lbl = new UILabel();
                lbl.AddBinding("Text", null);
                return lbl;
            }
        }
    }
}
