﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// Another dummy view model for nested data context testing purpose.
    /// </summary>
    public class SubViewModel2 : DummyViewModel
    {
        /// <summary>
        /// Backing field for the Value property.
        /// </summary>
        private float value;

        /// <summary>
        /// Backing field for the StringViewModel property.
        /// </summary>
        private StringViewModel stringViewModel = new StringViewModel();

        /// <summary>
        /// Gets or sets the value.
        /// </summary>
        public float Value
        {
            get
            {
                return this.value;
            }

            set
            {
                this.SetValue(ref this.value, value);
            }
        }

        /// <summary>
        /// Gets or sets the StringViewModel.
        /// </summary>
        public StringViewModel StringViewModel
        {
            get
            {
                return this.stringViewModel;
            }

            set
            {
                this.SetValue(ref this.stringViewModel, value);
            }
        }
    }
}
