﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;

namespace Test.EffectMaker.UIControls.TestTypes
{
    /// <summary>
    /// An extended DummyViewModel that contains an observable
    /// collection of FullyObservableViewModel items.
    /// </summary>
    public class FullyObservableViewModel : DummyViewModel
    {
        /// <summary>
        /// Backing field for the Items property.
        /// </summary>
        private ObservableCollection<FullyObservableViewModel> items =
            new ObservableCollection<FullyObservableViewModel>();

        /// <summary>
        /// Gets or set the child items.
        /// </summary>
        public ObservableCollection<FullyObservableViewModel> Items
        {
            get { return this.items; }
            set { this.SetValue(ref this.items, value); }
        }
    }
}
