﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.IO;
using System.Text;
using EffectMaker.Foundation.Serialization;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.EffectMaker.Foundation.TestTypes;

namespace Test.EffectMaker.Foundation.UnitTests
{
    /// <summary>
    /// Test class for features related to serialization.
    /// </summary>
    [TestClass]
    public class SerializableUnitTests
    {
        /// <summary>
        /// Test the Load and Save methods of the SerializationHelper class.
        /// </summary>
        [TestMethod]
        public void TestMethod1()
        {
            var test = new TestSerializable();

            test.Name = "a";
            test.Age = 10;

            var store = new MemoryStream();

            SerializationHelper.Save(test, store);

            var str = Encoding.UTF8.GetString(store.ToArray());

            Assert.AreEqual(str.Length, 61);

            store.Position = 0;
            TestSerializable restored = SerializationHelper.Load<TestSerializable>(store);

            Assert.AreEqual(restored.Name, "a");
            Assert.AreEqual(restored.Age, 10);
        }
    }
}
