﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Xml.Serialization;
using EffectMaker.Foundation.Serialization;

namespace Test.EffectMaker.Foundation.TestTypes
{
    /// <summary>
    /// Test class to serialize and deserialize data.
    /// </summary>
    public class TestSerializable
    {
        /// <summary>
        /// Backing field for the Name property.
        /// </summary>
        private string name;

        /// <summary>
        /// Backing field for the Age property.
        /// </summary>
        private int age;

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        [XmlAttribute]
        public string Name
        {
            get { return this.name; }
            set { this.name = value; }
        }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        [XmlAttribute]
        public int Age
        {
            get { return this.age; }
            set { this.age = value; }
        }
    }
}
