﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include <nw/dev.h>
#include <nw/eft/eft2_System.h>


//---------------------------------------------------
//  カスタムシェーダ クラス です。
//---------------------------------------------------
class CustomShaderSample
{
public:
    //------------------------------------------------------------------------------
    //  初期化
    //------------------------------------------------------------------------------
    static void Initialize( nw::eft2::System* system, nw::ut::IAllocator* allocator );

    //------------------------------------------------------------------------------
    //  ライトビューマトリクス設定
    //------------------------------------------------------------------------------
    static void SetLightViewProjectionMatrix( nw::math::Matrix44& matrix );

    //------------------------------------------------------------------------------
    //  描画設定後コールバック
    //------------------------------------------------------------------------------
    static bool _RenderStateSetCallback( nw::eft2::RenderStateSetArg& arg );

private:
    static nw::eftdemo::LightMapTexture     m_LightMap;         //!< 簡易ライトマップテクスチャ
    static nw::math::Matrix44               m_LightViewProj;    //!< ライトビュープロジェクションマトリクス
};
