﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Web.Script.Serialization;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace DevMenuCommandTest
{
    [TestClass]
    public class ShopTest
    {
        public TestContext TestContext { get; set; }

        [TestMethod]
        public void TestStart()
        {
            var command = new DevMenuCommandSystem(this.TestContext);

            Assert.IsTrue(command.Execute(new string[] {
                "servicediscovery import-all td1pass",
            }));

            // 初期状態からのショップ起動
            Assert.IsTrue(command.ResetAndExecute(new string[] {
                "account clear_all",
                "account add",
                "account link --index 0 --id eshop-test+psgcitd1_1@exmx.nintendo.co.jp --password psgcitd1_1",
                "shop unlink-device-all",
                "shop unregister-device-account",
                "shop start",
                "shop start",   // 二回目の入店
                "factoryreset do"
            }));

            Assert.IsTrue(command.ResetAndExecute(new string[] {
                "servicediscovery import-all td1pass",
            }));

            // 本体初期化後のショップ起動
            Assert.IsTrue(command.ResetAndExecute(new string[] {
                "account add",
                "account link --index 0 --id eshop-test+psgcitd1_1@exmx.nintendo.co.jp --password psgcitd1_1",
                "shop start",
                "factoryreset do-without-usersavedata"
            }));

            Assert.IsTrue(command.ResetAndExecute(new string[] {
                "servicediscovery import-all td1pass",
            }));

            // セーブデータを残して本体初期化後のショップ起動
            Assert.IsTrue(command.ResetAndExecute(new string[] {
                "shop start",
                "account clear_all",
                "shop unlink-device-all",
                "shop unregister-device-account",
            }));
        }
    }
}
