﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.IO;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;

namespace DevMenuCommandTest
{
    public class ProcessManager
    {
        static public Tuple<StringBuilder, StringBuilder> SetupProcess(Process process, string filename, string arguments)
        {
            var standardOutput = new StringBuilder();
            var standardError = new StringBuilder();

            process.StartInfo.FileName = filename;
            process.StartInfo.Arguments = arguments;
            process.StartInfo.CreateNoWindow = true;
            process.StartInfo.UseShellExecute = false;
            process.StartInfo.RedirectStandardOutput = true;
            process.StartInfo.RedirectStandardError = true;
            process.StartInfo.StandardOutputEncoding = System.Text.Encoding.UTF8;
            process.OutputDataReceived += (object sender, DataReceivedEventArgs e) =>
            {
                Console.WriteLine(e.Data);
                standardOutput.AppendLine(e.Data);
            };
            process.ErrorDataReceived += (object sender, DataReceivedEventArgs e) =>
            {
                Console.WriteLine(e.Data);
                standardError.AppendLine(e.Data);
            };

            Console.WriteLine(string.Format("Process.StartInfo.FileName: {0}", process.StartInfo.FileName));
            Console.WriteLine(string.Format("Process.StartInfo.Arguments: {0}", process.StartInfo.Arguments));

            return new Tuple<StringBuilder, StringBuilder>(standardOutput, standardError);
        }

        static public Tuple<StringBuilder, StringBuilder> SetupProcess(Process process, string filename, string arguments, FileStream fsStandardOutput, FileStream fsStandardError)
        {
            process.OutputDataReceived += (object sender, DataReceivedEventArgs e) =>
            {
                if (e.Data != null)
                {
                    fsStandardOutput.Write(Encoding.UTF8.GetBytes(e.Data + "\n"), 0, e.Data.Length + 1);
                }
            };
            process.ErrorDataReceived += (object sender, DataReceivedEventArgs e) =>
            {
                if (e.Data != null)
                {
                    fsStandardError.Write(Encoding.UTF8.GetBytes(e.Data + "\n"), 0, e.Data.Length + 1);
                }
            };
            return SetupProcess(process, filename, arguments);
        }

        static public void RunAndWaitProcess(Process process)
        {
            Console.WriteLine("Process.Start()");
            process.Start();
            process.BeginOutputReadLine();
            process.BeginErrorReadLine();
            Console.WriteLine("Process.WaitForExit()");
            process.WaitForExit();
        }
    }
}
