﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Text;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace DevMaintenanceMenuTest
{
    [TestClass]
    public class SetDevMaintenanceMenuTest
    {
        public TestContext TestContext { get; set; }
        private static string m_TargetName = string.Empty;
        private static string m_TargetInterface = string.Empty;

        [ClassInitialize]
        public static void TestClassinitialize(TestContext context)
        {
            m_TargetName = (string)context.Properties["TargetName"];
            m_TargetInterface = (string)context.Properties["TargetInterface"];
        }

        private bool ExecuteDevMenuCommandSystem(string exeArgs, string nspArgs)
        {
            var testPath = new TestUtility.TestPath(this.TestContext);

            return ExecuteDevMenuCommandCommon(exeArgs, nspArgs, testPath.GetSigloRoot() + "\\Programs\\Eris\\Outputs\\NX-NXFP2-a64\\TargetTools\\DevMenuCommandSystem\\Release\\DevMenuCommandSystem.nsp");
        }

        private Tuple<StringBuilder, StringBuilder> SetupProcess(Process process, string filename, string arguments)
        {
            var standardOutput = new StringBuilder();
            var standardError = new StringBuilder();

            process.StartInfo.FileName = filename;
            process.StartInfo.Arguments = arguments;
            process.StartInfo.CreateNoWindow = true;
            process.StartInfo.UseShellExecute = false;
            process.StartInfo.RedirectStandardOutput = true;
            process.StartInfo.RedirectStandardError = true;
            process.StartInfo.StandardOutputEncoding = System.Text.Encoding.UTF8;
            process.OutputDataReceived += (object sender, DataReceivedEventArgs e) =>
            {
                standardOutput.AppendLine(e.Data);
            };
            process.ErrorDataReceived += (object sender, DataReceivedEventArgs e) =>
            {
                standardError.AppendLine(e.Data);
            };

            return new Tuple<StringBuilder, StringBuilder>(standardOutput, standardError);
        }
        private void RunAndWaitProcess(Process process)
        {
            Console.WriteLine("process start.");
            process.Start();
            process.BeginOutputReadLine();
            process.BeginErrorReadLine();
            Console.WriteLine("process wait for exit.");
            process.WaitForExit();
        }

        private bool ExecuteDevMenuCommandCommon(string exeArgs, string nspArgs, string nspPath)
        {
            Console.WriteLine("ExecuteDevMenuCommandCommon start.");

            using (var process = new Process())
            {
                var testPath = new TestUtility.TestPath(this.TestContext);
                var filename = testPath.GetSigloRoot() + "\\Tools\\CommandLineTools\\RunOnTargetPrivate.exe";
                var arguments = $"run { nspPath } -t {m_TargetName} { exeArgs } --pattern-failure-exit \\[FAILURE\\] -- { nspArgs }";
                var outputs = SetupProcess(process, filename, arguments);
                RunAndWaitProcess(process);

                Console.WriteLine(string.Format("Standard Output: {0}", outputs.Item1.ToString()));
                Console.WriteLine(string.Format("Standard Error: {0}", outputs.Item2.ToString()));

                return process.ExitCode == 0;
            }
        }

        [TestMethod]
        public void TestDevMaintenanceMenu()
        {
            Console.WriteLine("TargetInteface: " + m_TargetInterface);
            Console.WriteLine("TargetName: " + m_TargetName);
            Console.WriteLine("TestDevMaintenanceMenu start.");
            var testPath = new TestUtility.TestPath(this.TestContext);

            if (m_TargetInterface == "HBX")
            {
                Assert.IsTrue(ExecuteDevMenuCommandSystem(string.Empty, "systemprogram install " + testPath.GetSigloRoot() + "\\Programs\\Iris\\Outputs\\NX-NXFP2-a64\\TargetTools\\DevMaintenanceMenu\\Release\\DevMaintenanceMenu.nsp --force"));
                Assert.IsTrue(ExecuteDevMenuCommandSystem(string.Empty, "debug enable-force-maintenance-mode"));
                Assert.IsTrue(ExecuteDevMenuCommandSystem("--reset --suppress-polling-process --pattern-success-exit \"\\[DevMaintenanceMenu\\] End\" --failure-timeout 120", "systemprogram list"));
                Assert.IsTrue(ExecuteDevMenuCommandSystem(string.Empty, "debug disable-force-maintenance-mode"));
                Assert.IsTrue(ExecuteDevMenuCommandSystem("--reset", "systemprogram list"));
            }
            else
            {
                // EDEV (m_TargetInterface == "USB") の場合、RunOnTargetProvate --suppress-polling-process が使えないため、テストを無条件で成功にさせる
                Console.WriteLine("TargetInterface isn't HBX. DevMaintenanceMenuTest finish unconditional success.");
            }
        }
    }
}
