﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using CredentialRegister;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace CredentialRegisterTest
{
    [TestClass]
    public class CredentialTest
    {
        [TestMethod]
        public void CredentialAnyTest()
        {
            var target = "CredentialTest/FindAuthenticationInfoTest";

            var authenticationInfo = new Credential.AuthenticationInfo()
            {
                Username = "hoge",
                Password = "fuga"
            };

            // 前回のテスト結果が中途半端に残っている可能性があるため、まずはクレデンシャルを削除します。
            {
                Credential.DeleteAuthenticationInfo(target);
            }

            // クレデンシャルは保存されていないので、見つかりません。
            {
                Credential.AuthenticationInfo result;

                var found = Credential.FindAuthenticationInfo(target, out result);

                Assert.IsFalse(found);
            }

            // クレデンシャルが存在しない場合も削除操作は可能です。
            {
                Credential.DeleteAuthenticationInfo(target);
            }

            // クレデンシャルを保存します。
            {
                Credential.SaveAuthenticationInfo(target, authenticationInfo);
            }

            // クレデンシャルは保存されているので、見つかります。
            {
                Credential.AuthenticationInfo result;

                var found = Credential.FindAuthenticationInfo(target, out result);

                Assert.IsTrue(found);
                Assert.AreEqual("hoge", result.Username);
                Assert.AreEqual("fuga", result.Password);
            }

            // クレデンシャルを削除します。
            {
                Credential.DeleteAuthenticationInfo(target);
            }

            // クレデンシャルは削除されたので、見つかりません。
            {
                Credential.AuthenticationInfo result;

                var found = Credential.FindAuthenticationInfo(target, out result);

                Assert.IsFalse(found);
            }
        }
    }
}
