﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

template <typename T>
T Func(T x)
{
    return x;
}

void VariableTest()
{
    int a = 123;
    int b = 456;
    int n;

    n = a % b;
    n = a %
        b;
    n = a
        % b;
    n = a% b;       //:) BAD
    n = a %b;       //:) BAD
    n = a%          //:) BAD
        b;
    n = a
        %b;         //:) BAD

    if (a % b)
    {
    }
    else if (a % b)
    {
    }

    if (a% b)           //:) BAD
    {
    }
    else if (a% b)      //:) BAD
    {
    }

    if (a %b)           //:) BAD
    {
    }
    else if (a %b)      //:) BAD
    {
    }

    for (int i = a % b; i < 10; ++i)
    {
    }
    for (int i = a% b; i < 10; ++i)       //:) BAD
    {
    }
    for (int i = a %b; i < 10; ++i)       //:) BAD
    {
    }

    for (int i = 0; i < a % b; ++i)
    {
    }
    for (int i = 0; i < a% b; ++i)        //:) BAD
    {
    }
    for (int i = 0; i < a %b; ++i)        //:) BAD
    {
    }

    for (int i = 0; i < 10; i += b % a)
    {
    }
    for (int i = 0; i < 10; i += b% a)    //:) BAD
    {
    }
    for (int i = 0; i < 10; i += b %a)    //:) BAD
    {
    }

    do
    {
    } while (0 < a % b);
    do
    {
    } while (0 < a% b); //:) BAD
    do
    {
    } while (0 < a %b); //:) BAD

    while (0 < a % b)
    {
    }
    while (0 < a% b)    //:) BAD
    {
    }
    while (0 < a %b)    //:) BAD
    {
    }

    switch (b % a)
    {
    default:
        break;
    }
    switch (b% a)       //:) BAD
    {
    default:
        break;
    }
    switch (b %a)       //:) BAD
    {
    default:
        break;
    }

    Func(a % b);
    Func(a% b);         //:) BAD
    Func(a %b);         //:) BAD
}

void DecimalTest()
{
    int n;

    n = 123 % 456;
    n = 123 %
        456;
    n = 123
        % 456;
    n = 123% 456;   //:) BAD
    n = 123 %456;   //:) BAD
    n = 123%        //:) BAD
        456;
    n = 123
        %456;       //:) BAD

    n = 123 % (456 % 789);
    n = 123 %
        (456 % 789);
    n = 123
        % (456 % 789);
    n = 123% (456 % 789);   //:) BAD
    n = 123 %(456 % 789);   //:) BAD
    n = 123%                //:) BAD
        (456 % 789);
    n = 123
        %(456 % 789);       //:) BAD

    n = (123 % 456) % 789;
    n = (123 % 456) %
        789;
    n = (123 % 456)
        % 789;
    n = (123 % 456)% 789;   //:) BAD
    n = (123 % 456) %789;   //:) BAD
    n = (123 % 456)%        //:) BAD
        789;
    n = (123 % 456)
        %789;               //:) BAD


    if (123 % 456)
    {
    }
    else if (123 % 456)
    {
    }

    if (123% 456)           //:) BAD
    {
    }
    else if (123% 456)      //:) BAD
    {
    }

    if (123 %456)           //:) BAD
    {
    }
    else if (123 %456)      //:) BAD
    {
    }

    for (int i = 123 % 456; i < 10; ++i)
    {
    }
    for (int i = 123% 456; i < 10; ++i)       //:) BAD
    {
    }
    for (int i = 123 %456; i < 10; ++i)       //:) BAD
    {
    }

    for (int i = 0; i < 123 % 456; ++i)
    {
    }
    for (int i = 0; i < 123% 456; ++i)        //:) BAD
    {
    }
    for (int i = 0; i < 123 %456; ++i)        //:) BAD
    {
    }

    for (int i = 0; i < 10; i += 456 % 123)
    {
    }
    for (int i = 0; i < 10; i += 456% 123)    //:) BAD
    {
    }
    for (int i = 0; i < 10; i += 456 %123)    //:) BAD
    {
    }

    do
    {
    } while (0 < 123 % 456);
    do
    {
    } while (0 < 123% 456); //:) BAD
    do
    {
    } while (0 < 123 %456); //:) BAD

    while (0 < 123 % 456)
    {
    }
    while (0 < 123% 456)    //:) BAD
    {
    }
    while (0 < 123 %456)    //:) BAD
    {
    }

    switch (456 % 123)
    {
    default:
        break;
    }
    switch (456% 123)       //:) BAD
    {
    default:
        break;
    }
    switch (456 %123)       //:) BAD
    {
    default:
        break;
    }

    Func(123 % 456);
    Func(123% 456);         //:) BAD
    Func(123 %456);         //:) BAD
}

void HexTest()
{
    int n;

    n = 0x123 % 0x456;
    n = 0x123 %
        0x456;
    n = 0x123
        % 0x456;
    n = 0x123% 0x456;   //:) BAD
    n = 0x123 %0x456;   //:) BAD
    n = 0x123%          //:) BAD
        0x456;
    n = 0x123
        %0x456;         //:) BAD

    n = 0x123 % (0x456 % 0x789);
    n = 0x123 %
        (0x456 % 0x789);
    n = 0x123
        % (0x456 % 0x789);
    n = 0x123% (0x456 % 0x789);   //:) BAD
    n = 0x123 %(0x456 % 0x789);   //:) BAD
    n = 0x123%                    //:) BAD
        (0x456 % 0x789);
    n = 0x123
        %(0x456 % 0x789);         //:) BAD

    n = (0x123 % 0x456) % 0x789;
    n = (0x123 % 0x456) %
        0x789;
    n = (0x123 % 0x456)
        % 0x789;
    n = (0x123 % 0x456)% 0x789;   //:) BAD
    n = (0x123 % 0x456) %0x789;   //:) BAD
    n = (0x123 % 0x456)%          //:) BAD
        0x789;
    n = (0x123 % 0x456)
        %0x789;                   //:) BAD

    if (0x123 % 0x456)
    {
    }
    else if (0x123 % 0x456)
    {
    }

    if (0x123% 0x456)           //:) BAD
    {
    }
    else if (0x123% 0x456)      //:) BAD
    {
    }

    if (0x123 %0x456)           //:) BAD
    {
    }
    else if (0x123 %0x456)      //:) BAD
    {
    }

    for (int i = 0x123 % 0x456; i < 10; ++i)
    {
    }
    for (int i = 0x123% 0x456; i < 10; ++i)       //:) BAD
    {
    }
    for (int i = 0x123 %0x456; i < 10; ++i)       //:) BAD
    {
    }

    for (int i = 0; i < 0x123 % 0x456; ++i)
    {
    }
    for (int i = 0; i < 0x123% 0x456; ++i)        //:) BAD
    {
    }
    for (int i = 0; i < 0x123 %0x456; ++i)        //:) BAD
    {
    }

    for (int i = 0; i < 10; i += 0x456 % 0x123)
    {
    }
    for (int i = 0; i < 10; i += 0x456% 0x123)    //:) BAD
    {
    }
    for (int i = 0; i < 10; i += 0x456 %0x123)    //:) BAD
    {
    }

    do
    {
    } while (0 < 0x123 % 0x456);
    do
    {
    } while (0 < 0x123% 0x456); //:) BAD
    do
    {
    } while (0 < 0x123 %0x456); //:) BAD

    while (0 < 0x123 % 0x456)
    {
    }
    while (0 < 0x123% 0x456)    //:) BAD
    {
    }
    while (0 < 0x123 %0x456)    //:) BAD
    {
    }

    switch (0x456 % 0x123)
    {
    default:
        break;
    }
    switch (0x456% 0x123)       //:) BAD
    {
    default:
        break;
    }
    switch (0x456 %0x123)       //:) BAD
    {
    default:
        break;
    }

    Func(0x123 % 0x456);
    Func(0x123% 0x456);         //:) BAD
    Func(0x123 %0x456);         //:) BAD
}
