﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using CommitContentChecker;
using TestUtility;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace CommitContentCheckerTest
{
    [TestClass]
    public class FilePathCheckerTest
    {
        public TestContext TestContext { get; set; }

        [TestMethod]
        public void CheckLengthTest()
        {
            TestPath testPath = new TestPath(TestContext);
            string resourceRoot = testPath.GetToolTestResourceDirectory();

            // パスが長すぎるファイルを実ファイルシステム上に作成するのが困難なので、 CheckAll ではなく CheckLength を呼んでテストを行う
            Assert.IsTrue(FilePathChecker.CheckLength(new string('a', FilePathChecker.PathLengthMax)));
            Assert.IsFalse(FilePathChecker.CheckLength(new string('a', FilePathChecker.PathLengthMax + 1)));
        }

        [TestMethod]
        public void CheckCasingTest()
        {
            TestPath testPath = new TestPath(TestContext);
            string resourceRoot = testPath.GetToolTestResourceDirectory();

            // ファイルパスがファイルシステム上のパスと一致する場合
            Assert.IsTrue(FilePathChecker.CheckAll(Path.Combine(resourceRoot, "PreCommitCheckerTestData/DummyFiles/DummyFile.txt")));

            // ファイル名の大文字小文字がファイルシステム上のパスと異なる場合
            Assert.IsFalse(FilePathChecker.CheckAll(Path.Combine(resourceRoot, "PreCommitCheckerTestData/DummyFiles/dummyfile.txt")));

            // ディレクトリ名の大文字小文字がファイルシステム上のパスと異なる場合
            Assert.IsFalse(FilePathChecker.CheckAll(Path.Combine(resourceRoot, "precommitcheckertestdata/dummyfiles/DummyFile.txt")));

            // ディレクトリ名の大文字小文字がファイルシステム上のパスと異なり、かつファイルシステム上に存在しないファイルである場合
            Assert.IsFalse(FilePathChecker.CheckAll(Path.Combine(resourceRoot, "precommitcheckertestdata/dummyfiles/NoEntry")));

            // ディレクトリ名の大文字小文字がファイルシステム上のパスと異なり、かつファイルシステム上に存在しないディレクトリを含む場合
            Assert.IsFalse(FilePathChecker.CheckAll(Path.Combine(resourceRoot, "precommitcheckertestdata/dummyfiles/NoEntries/NoEntry")));
        }
    }
}
